/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.hedera.hapi.node.state.history.WrapsPhase;
import com.hedera.node.app.history.ReadableHistoryStore;
import com.hedera.node.app.service.roster.impl.RosterTransitionWeights;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class WrapsMpcStateMachine {
    @Inject
    public WrapsMpcStateMachine() {
    }

    public Transition onNext(@NonNull ReadableHistoryStore.WrapsMessagePublication publication, @NonNull WrapsPhase currentPhase, @NonNull RosterTransitionWeights weights, @NonNull Duration gracePeriod, @NonNull Map<WrapsPhase, SortedMap<Long, ReadableHistoryStore.WrapsMessagePublication>> phaseMessages) {
        Objects.requireNonNull(publication);
        Objects.requireNonNull(currentPhase);
        Objects.requireNonNull(weights);
        Objects.requireNonNull(gracePeriod);
        Objects.requireNonNull(phaseMessages);
        if (currentPhase == WrapsPhase.AGGREGATE) {
            return Transition.rejectedAt(WrapsPhase.AGGREGATE);
        }
        if (publication.phase() != currentPhase) {
            return Transition.rejectedAt(currentPhase);
        }
        SortedMap messages = phaseMessages.computeIfAbsent(currentPhase, p -> new TreeMap());
        if (currentPhase == WrapsPhase.R1) {
            if (messages.putIfAbsent(publication.nodeId(), publication) != null) {
                return Transition.rejectedAt(currentPhase);
            }
            long r1Weight = messages.values().stream().mapToLong(p -> weights.sourceWeightOf(p.nodeId())).sum();
            if (r1Weight >= RosterTransitionWeights.moreThanHalfOfTotal((Map)weights.sourceNodeWeights())) {
                return Transition.advanceTo(WrapsPhase.R2, publication.receiptTime().plus(gracePeriod));
            }
        } else {
            Set<Long> r1Nodes = phaseMessages.get(WrapsPhase.R1).keySet();
            if (!r1Nodes.contains(publication.nodeId())) {
                return Transition.rejectedAt(currentPhase);
            }
            if (messages.putIfAbsent(publication.nodeId(), publication) != null) {
                return Transition.rejectedAt(currentPhase);
            }
            if (messages.keySet().containsAll(r1Nodes)) {
                WrapsPhase nextPhase = currentPhase == WrapsPhase.R2 ? WrapsPhase.R3 : WrapsPhase.AGGREGATE;
                Instant nextGracePeriodEndTime = currentPhase == WrapsPhase.R2 ? publication.receiptTime().plus(gracePeriod) : null;
                return Transition.advanceTo(nextPhase, nextGracePeriodEndTime);
            }
        }
        return Transition.incorporatedIn(currentPhase);
    }

    public record Transition(boolean publicationAccepted, @NonNull WrapsPhase newCurrentPhase, @Nullable Instant gracePeriodEndTimeUpdate) {
        public Transition {
            Objects.requireNonNull(newCurrentPhase);
        }

        public static Transition rejectedAt(@NonNull WrapsPhase currentPhase) {
            return new Transition(false, currentPhase, null);
        }

        public static Transition incorporatedIn(@NonNull WrapsPhase currentPhase) {
            return new Transition(true, currentPhase, null);
        }

        public static Transition advanceTo(@NonNull WrapsPhase currentPhase, @Nullable Instant gracePeriodEndTimeUpdate) {
            return new Transition(true, currentPhase, gracePeriodEndTimeUpdate);
        }
    }
}

