/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.common;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallTranslator;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public abstract class AbstractCallTranslator<T extends AbstractCallAttempt<T>>
implements CallTranslator<T> {
    private final SystemContractMethod.SystemContract systemContractKind;
    private final SystemContractMethodRegistry systemContractMethodRegistry;
    private final ContractMetrics contractMetrics;

    public AbstractCallTranslator(@NonNull SystemContractMethod.SystemContract systemContractKind, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        this.systemContractKind = Objects.requireNonNull(systemContractKind);
        this.systemContractMethodRegistry = Objects.requireNonNull(systemContractMethodRegistry);
        this.contractMetrics = Objects.requireNonNull(contractMetrics);
    }

    @Override
    @Nullable
    public Call translateCallAttempt(@NonNull T attempt) {
        Objects.requireNonNull(attempt);
        Call call = this.identifyMethod(attempt).map(this.systemContractMethodRegistry::fromMissingContractGetWithContract).map(systemContractMethod -> this.callFrom(attempt, (SystemContractMethod)systemContractMethod)).orElse(null);
        if (call != null && call.getSystemContractMethod() == null) {
            this.contractMetrics.logWarnMissingSystemContractMethodOnCall(this.identifyMethod(attempt).orElseThrow());
        }
        return call;
    }

    public void registerMethods(SystemContractMethod ... methods) {
        Objects.requireNonNull(methods);
        for (SystemContractMethod method : methods) {
            Objects.requireNonNull(method);
            this.registerMethod(method, method.withContract(this.systemContractKind));
        }
    }

    private void registerMethod(@NonNull SystemContractMethod methodWithoutContract, @NonNull SystemContractMethod methodWithContract) {
        Objects.requireNonNull(methodWithoutContract);
        Objects.requireNonNull(methodWithContract);
        methodWithContract.verifyComplete();
        if (this.systemContractMethodRegistry != null) {
            this.systemContractMethodRegistry.register(methodWithoutContract, methodWithContract);
        }
    }

    @VisibleForTesting
    @NonNull
    public String kind() {
        return this.systemContractKind != null ? this.systemContractKind.name() : "<UNKNOWN-CONTRACT>";
    }
}

