/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.hashgraph.internal;

import com.swirlds.platform.gui.hashgraph.internal.PictureMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.hashgraph.impl.EventImpl;

public class EventSelector
implements MouseListener {
    private EventImpl selectedEvent = null;
    private final List<EventImpl> stronglySeen = new ArrayList<EventImpl>();
    private PictureMetadata metadata = null;
    private List<EventImpl> eventsInPicture = List.of();

    public void setMetadata(@NonNull PictureMetadata metadata) {
        Objects.requireNonNull(metadata);
        this.metadata = metadata;
    }

    public void setEventsInPicture(@NonNull List<EventImpl> eventsInPicture) {
        Objects.requireNonNull(eventsInPicture);
        this.eventsInPicture = eventsInPicture;
    }

    public boolean isSelected(@NonNull EventImpl event) {
        Objects.requireNonNull(event);
        return event == this.selectedEvent;
    }

    public boolean isStronglySeen(@NonNull EventImpl event) {
        Objects.requireNonNull(event);
        return this.stronglySeen.stream().anyMatch(e -> e == event);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (this.metadata == null) {
            return;
        }
        int xClicked = me.getX();
        int yClicked = me.getY();
        int rSquared = this.metadata.getD() * this.metadata.getD() / 4;
        this.stronglySeen.clear();
        for (EventImpl e : this.eventsInPicture) {
            int xEvent = this.metadata.xpos(e);
            int yEvent = this.metadata.ypos(e);
            double distanceSquared = Math.pow(xEvent - xClicked, 2.0) + Math.pow(yEvent - yClicked, 2.0);
            if (!(distanceSquared <= (double)(rSquared - 20))) continue;
            if (this.selectedEvent == e) {
                this.selectedEvent = null;
            } else {
                this.selectedEvent = e;
                if (this.selectedEvent.getStronglySeeP() != null) {
                    Arrays.stream(this.selectedEvent.getStronglySeeP()).filter(Objects::nonNull).forEach(this.stronglySeen::add);
                }
            }
            return;
        }
        this.selectedEvent = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

