/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.internal;

import com.swirlds.platform.gui.GuiUtils;
import com.swirlds.platform.gui.components.PrePaintableJPanel;
import com.swirlds.platform.gui.internal.WinBrowser;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import javax.swing.JTextArea;
import org.hiero.consensus.hashgraph.impl.consensus.Consensus;
import org.hiero.consensus.model.node.NodeId;

class WinTab2Consensus
extends PrePaintableJPanel {
    private static final long serialVersionUID = 1L;
    private JTextArea text = GuiUtils.newJTextArea("");
    private final Consensus consensus;
    private final NodeId firstNodeId;

    public WinTab2Consensus(@NonNull Consensus consensus, @NonNull NodeId firstNodeId) {
        this.consensus = Objects.requireNonNull(consensus);
        this.firstNodeId = Objects.requireNonNull(firstNodeId);
        this.add(this.text);
    }

    @Override
    public void prePaint() {
        try {
            if (WinBrowser.memberDisplayed == null) {
                return;
            }
            Object s = "";
            s = (String)s + "Node" + this.firstNodeId.id();
            long rd = this.consensus.getFameDecidedBelow();
            long rc = this.consensus.getMaxRound();
            s = (String)s + String.format("\n%,10d = latest round-decided", rd);
            s = (String)s + String.format("\n%,10d = latest round-created", rc);
            this.text.setFont(new Font("monospaced", 0, 14));
            this.text.setText((String)s);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }
}

