/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.staking;

import com.hedera.hapi.node.base.Fraction;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.token.NetworkStakingRewards;
import com.hedera.hapi.node.state.token.StakingNodeInfo;
import com.hedera.hapi.node.transaction.NodeStake;
import com.hedera.hapi.node.transaction.NodeStakeUpdateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.token.ReadableNetworkStakingRewardsStore;
import com.hedera.node.config.data.StakingConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

public final class EndOfStakingPeriodUtils {
    private EndOfStakingPeriodUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static String readableNonZeroHistory(@NonNull List<Long> rewardSumHistory) {
        int firstZero = -1;
        for (int i = 0; i < rewardSumHistory.size(); ++i) {
            if (rewardSumHistory.get(i) != 0L) continue;
            firstZero = i;
            break;
        }
        return firstZero == -1 ? rewardSumHistory.toString() : IntStream.range(0, firstZero).mapToObj(rewardSumHistory::get).toList().toString();
    }

    public static NodeStake fromStakingInfo(long rewardRate, @NonNull StakingNodeInfo stakingNodeInfo) {
        Objects.requireNonNull(stakingNodeInfo);
        return NodeStake.newBuilder().nodeId(stakingNodeInfo.nodeNumber()).stake(stakingNodeInfo.stake()).rewardRate(rewardRate).minStake(stakingNodeInfo.minStake()).maxStake(stakingNodeInfo.maxStake()).stakeRewarded(stakingNodeInfo.stakeToReward()).stakeNotRewarded(stakingNodeInfo.stakeToNotReward()).build();
    }

    public static NetworkStakingRewards.Builder asStakingRewardBuilder(@NonNull ReadableNetworkStakingRewardsStore networkRewardsStore) {
        Objects.requireNonNull(networkRewardsStore);
        return networkRewardsStore.get().copyBuilder().pendingRewards(networkRewardsStore.pendingRewards()).stakingRewardsActivated(networkRewardsStore.isStakingRewardsActivated()).totalStakedRewardStart(networkRewardsStore.totalStakeRewardStart()).totalStakedStart(networkRewardsStore.totalStakedStart());
    }

    public static TransactionBody.Builder newNodeStakeUpdateBuilder(@NonNull Timestamp stakingPeriodEnd, @NonNull List<NodeStake> nodeStakes, @NonNull StakingConfig stakingConfig, long totalStakedRewardStart, long maxPerHbarRewardRate, long reservedStakingRewards, long unreservedStakingRewardBalance, @NonNull String memo) {
        Objects.requireNonNull(stakingPeriodEnd);
        Objects.requireNonNull(nodeStakes);
        Objects.requireNonNull(stakingConfig);
        Objects.requireNonNull(memo);
        NodeStakeUpdateTransactionBody txnBody = EndOfStakingPeriodUtils.newNodeStakeUpdate(stakingPeriodEnd, nodeStakes, stakingConfig, totalStakedRewardStart, maxPerHbarRewardRate, reservedStakingRewards, unreservedStakingRewardBalance);
        return TransactionBody.newBuilder().memo(memo).nodeStakeUpdate(txnBody);
    }

    public static NodeStakeUpdateTransactionBody newNodeStakeUpdate(@NonNull Timestamp stakingPeriodEnd, @NonNull List<NodeStake> nodeStakes, @NonNull StakingConfig stakingConfig, long totalStakedRewardStart, long maxPerHbarRewardRate, long reservedStakingRewards, long unreservedStakingRewardBalance) {
        long hbarsStakedToReward = totalStakedRewardStart / 100000000L;
        long maxTotalReward = maxPerHbarRewardRate * hbarsStakedToReward;
        Fraction nodeRewardFeeFraction = Fraction.newBuilder().numerator((long)stakingConfig.feesNodeRewardPercentage()).denominator(100L).build();
        Fraction stakingRewardFeeFraction = Fraction.newBuilder().numerator((long)stakingConfig.feesStakingRewardPercentage()).denominator(100L).build();
        return NodeStakeUpdateTransactionBody.newBuilder().endOfStakingPeriod(stakingPeriodEnd).nodeStake(nodeStakes).maxStakingRewardRatePerHbar(maxPerHbarRewardRate).nodeRewardFeeFraction(nodeRewardFeeFraction).stakingPeriodsStored((long)stakingConfig.rewardHistoryNumStoredPeriods()).stakingPeriod(stakingConfig.periodMins()).stakingRewardFeeFraction(stakingRewardFeeFraction).stakingStartThreshold(stakingConfig.startThreshold()).stakingRewardRate(maxTotalReward).maxTotalReward(maxTotalReward).reservedStakingRewards(reservedStakingRewards).unreservedStakingRewardBalance(unreservedStakingRewardBalance).rewardBalanceThreshold(stakingConfig.rewardBalanceThreshold()).maxStakeRewarded(stakingConfig.maxStakeRewarded()).build();
    }

    public static Timestamp lastInstantOfPreviousPeriodFor(@NonNull Instant consensusTime) {
        LocalDateTime justBeforeMidNightTime = LocalDate.ofInstant(consensusTime, ZoneId.of("UTC")).atStartOfDay().minusNanos(1L);
        return Timestamp.newBuilder().seconds(justBeforeMidNightTime.toEpochSecond(ZoneOffset.UTC)).nanos(justBeforeMidNightTime.getNano()).build();
    }

    public static RewardSumHistory computeExtendedRewardSumHistory(@NonNull StakingNodeInfo currentInfo, long perHbarRate, long maxPerHbarRate, boolean requireMinStakeToReward) {
        long rewardableStake;
        List currRewardSumHistory = currentInfo.rewardSumHistory();
        ArrayList<Long> newRewardSumHistory = new ArrayList<Long>(currRewardSumHistory);
        Long droppedRewardSum = (Long)currRewardSumHistory.getLast();
        for (int i = currRewardSumHistory.size() - 1; i > 0; --i) {
            newRewardSumHistory.set(i, (Long)currRewardSumHistory.get(i - 1) - droppedRewardSum);
        }
        newRewardSumHistory.set(0, (Long)currRewardSumHistory.getFirst() - droppedRewardSum);
        long perHbarRateThisNode = 0L;
        long l = rewardableStake = requireMinStakeToReward ? Math.min(currentInfo.stakeRewardStart(), currentInfo.stake()) : currentInfo.stakeRewardStart();
        if (rewardableStake > 0L) {
            perHbarRateThisNode = perHbarRate;
            if (currentInfo.stakeRewardStart() > currentInfo.maxStake()) {
                perHbarRateThisNode = BigInteger.valueOf(perHbarRateThisNode).multiply(BigInteger.valueOf(currentInfo.maxStake())).divide(BigInteger.valueOf(currentInfo.stakeRewardStart())).longValueExact();
            }
        }
        perHbarRateThisNode = Math.min(perHbarRateThisNode, maxPerHbarRate);
        newRewardSumHistory.set(0, (Long)newRewardSumHistory.getFirst() + perHbarRateThisNode);
        return new RewardSumHistory(newRewardSumHistory, perHbarRateThisNode);
    }

    @NonNull
    public static StakeResult computeNewStakes(@NonNull StakingNodeInfo stakingInfo, @NonNull StakingConfig stakingConfig) {
        Objects.requireNonNull(stakingInfo);
        Objects.requireNonNull(stakingConfig);
        long totalStake = stakingInfo.stakeToReward() + stakingInfo.stakeToNotReward();
        long effectiveMax = Math.min(stakingInfo.maxStake(), stakingConfig.maxStake());
        long effectiveMin = Math.min(effectiveMax, Math.max(stakingInfo.minStake(), stakingConfig.minStake()));
        long newStake = totalStake > effectiveMax ? effectiveMax : (totalStake < effectiveMin ? 0L : totalStake);
        return new StakeResult(newStake, stakingInfo.stakeToReward());
    }

    public record RewardSumHistory(List<Long> rewardSumHistory, long pendingRewardRate) {
    }

    public record StakeResult(long stake, long stakeRewardStart) {
    }
}

