/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import org.identityconnectors.common.Version;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.impl.api.local.ConnectorBundleManifest;

public final class ConnectorBundleManifestParser {
    private static final String BUNDLE_PREFIX = "ConnectorBundle-";
    private static final String ATT_FRAMEWORK_VERSION = "ConnectorBundle-FrameworkVersion";
    private static final String ATT_BUNDLE_NAME = "ConnectorBundle-Name";
    private static final String ATT_BUNDLE_VERSION = "ConnectorBundle-Version";
    private final String _fileName;
    private final Map<String, String> _attributes;

    public ConnectorBundleManifestParser(String fileName, Manifest manifest) {
        this._fileName = fileName;
        this._attributes = ConnectorBundleManifestParser.getAttributes(manifest);
    }

    private static Map<String, String> getAttributes(Manifest manifest) {
        HashMap<String, String> rv = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : manifest.getMainAttributes().entrySet()) {
            rv.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return Collections.unmodifiableMap(rv);
    }

    public ConnectorBundleManifest parse() throws ConfigurationException {
        String frameworkVersion = this.getRequiredAttribute(ATT_FRAMEWORK_VERSION);
        String bundleName = this.getRequiredAttribute(ATT_BUNDLE_NAME);
        String bundleVersion = this.getRequiredAttribute(ATT_BUNDLE_VERSION);
        if (FrameworkUtil.getFrameworkVersion().compareTo(Version.parse((String)frameworkVersion)) < 0) {
            String message = "Bundle " + this._fileName + " requests an unrecognized " + "framework version " + frameworkVersion + " but available is " + FrameworkUtil.getFrameworkVersion().getVersion();
            throw new ConfigurationException(message);
        }
        ConnectorBundleManifest rv = new ConnectorBundleManifest();
        rv.setFrameworkVersion(frameworkVersion);
        rv.setBundleName(bundleName);
        rv.setBundleVersion(bundleVersion);
        return rv;
    }

    private String getRequiredAttribute(String name) throws ConfigurationException {
        String rv = this.getAttribute(name);
        if (rv == null) {
            String msg = "Bundle " + this._fileName + " is missing required attribute '" + name + "'.";
            throw new ConfigurationException(msg);
        }
        return rv;
    }

    private String getAttribute(String name) {
        return this._attributes.get(name);
    }
}

