/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.hashgraph.internal;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.platform.gui.GuiEventStorage;
import com.swirlds.platform.gui.hashgraph.HashgraphGuiSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.hashgraph.impl.EventImpl;

public class StandardGuiSource
implements HashgraphGuiSource {
    private final Roster roster;
    private final GuiEventStorage eventStorage;

    public StandardGuiSource(@NonNull Roster roster, @NonNull GuiEventStorage eventStorage) {
        this.roster = Objects.requireNonNull(roster);
        this.eventStorage = Objects.requireNonNull(eventStorage);
    }

    @Override
    public long getMaxGeneration() {
        return this.eventStorage.getMaxGeneration();
    }

    @Override
    @NonNull
    public List<EventImpl> getEvents(long startGeneration, int numGenerations) {
        return this.eventStorage.getNonAncientEvents().stream().filter(e -> e.getNGen() >= startGeneration && e.getNGen() < startGeneration + (long)numGenerations).toList();
    }

    @Override
    @NonNull
    public Roster getRoster() {
        return this.roster;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public GuiEventStorage getEventStorage() {
        return this.eventStorage;
    }
}

