/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.util;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.util.HapiUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.export.ConfigExport;
import com.swirlds.config.extensions.sources.LegacyFileConfigSource;
import com.swirlds.config.extensions.sources.YamlConfigSource;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.JVMPauseDetectorThread;
import com.swirlds.platform.config.PathsConfig;
import com.swirlds.platform.config.internal.ConfigMappings;
import com.swirlds.platform.config.legacy.ConfigurationException;
import com.swirlds.platform.health.OSHealthCheckConfig;
import com.swirlds.platform.health.OSHealthChecker;
import com.swirlds.platform.health.clock.OSClockSpeedSourceChecker;
import com.swirlds.platform.health.entropy.OSEntropyChecker;
import com.swirlds.platform.health.filesystem.OSFileSystemChecker;
import com.swirlds.platform.state.service.PlatformStateUtils;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.system.SystemExitCode;
import com.swirlds.platform.system.SystemExitUtils;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.consensus.config.BasicConfig;
import org.hiero.consensus.model.node.NodeId;

public final class BootstrapUtils {
    private static final Logger logger = LogManager.getLogger(BootstrapUtils.class);

    private BootstrapUtils() {
    }

    public static void setupConfigBuilder(@NonNull ConfigurationBuilder configurationBuilder, @NonNull Path settingsPath) throws IOException {
        BootstrapUtils.setupConfigBuilder(configurationBuilder, settingsPath, null);
    }

    public static void setupConfigBuilder(@NonNull ConfigurationBuilder configurationBuilder, @NonNull Path settingsPath, @Nullable Path nodeOverridesPath) throws IOException {
        LegacyFileConfigSource settingsConfigSource = LegacyFileConfigSource.ofSettingsFile((Path)settingsPath);
        ConfigSource mappedSettingsConfigSource = ConfigMappings.addConfigMapping((ConfigSource)settingsConfigSource);
        configurationBuilder.autoDiscoverExtensions().withSource(mappedSettingsConfigSource);
        if (nodeOverridesPath != null) {
            YamlConfigSource yamlConfigSource = new YamlConfigSource(nodeOverridesPath);
            configurationBuilder.withSource((ConfigSource)yamlConfigSource);
        }
    }

    public static void performHealthChecks(@NonNull Path settingsPath, @NonNull Configuration configuration) {
        Objects.requireNonNull(configuration);
        OSFileSystemChecker osFileSystemChecker = new OSFileSystemChecker(settingsPath);
        OSHealthChecker.performOSHealthChecks((OSHealthCheckConfig)configuration.getConfigData(OSHealthCheckConfig.class), List.of(OSClockSpeedSourceChecker::performClockSourceSpeedCheck, OSEntropyChecker::performEntropyChecks, osFileSystemChecker::performFileSystemCheck));
    }

    public static void setupConstructableRegistry() {
        try {
            ConstructableRegistry.getInstance().registerConstructables("");
        }
        catch (ConstructableRegistryException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean detectSoftwareUpgrade(@NonNull SemanticVersion appVersion, @Nullable SignedState loadedSignedState) {
        boolean softwareUpgrade;
        int versionComparison;
        SemanticVersion loadedSoftwareVersion;
        Objects.requireNonNull(appVersion, "The app version must not be null.");
        if (loadedSignedState == null) {
            loadedSoftwareVersion = null;
        } else {
            MerkleNodeState state = loadedSignedState.getState();
            loadedSoftwareVersion = PlatformStateUtils.creationSoftwareVersionOf((State)state);
        }
        int n = versionComparison = loadedSoftwareVersion == null ? 1 : HapiUtils.SEMANTIC_VERSION_COMPARATOR.compare(appVersion, loadedSoftwareVersion);
        if (versionComparison < 0) {
            throw new IllegalStateException("The current software version `" + String.valueOf(appVersion) + "` is prior to the software version `" + String.valueOf(loadedSoftwareVersion) + "` that created the state that was loaded from disk.");
        }
        if (versionComparison > 0) {
            softwareUpgrade = true;
            logger.info(LogMarker.STARTUP.getMarker(), "Software upgrade in progress. Previous software version was {}, current version is {}.", (Object)loadedSoftwareVersion, (Object)appVersion);
        } else {
            softwareUpgrade = false;
            logger.info(LogMarker.STARTUP.getMarker(), "Not upgrading software, current software is version {}.", (Object)appVersion);
        }
        return softwareUpgrade;
    }

    public static void startJVMPauseDetectorThread(@NonNull Configuration configuration) {
        Objects.requireNonNull(configuration);
        BasicConfig basicConfig = (BasicConfig)configuration.getConfigData(BasicConfig.class);
        if (basicConfig.jvmPauseDetectorSleepMs() > 0) {
            JVMPauseDetectorThread jvmPauseDetectorThread = new JVMPauseDetectorThread((pauseTimeMs, allocTimeMs) -> {
                if (pauseTimeMs > (long)basicConfig.jvmPauseReportMs()) {
                    logger.warn(LogMarker.EXCEPTION.getMarker(), "jvmPauseDetectorThread detected JVM paused for {} ms, allocation pause {} ms", (Object)pauseTimeMs, (Object)allocTimeMs);
                }
            }, basicConfig.jvmPauseDetectorSleepMs());
            jvmPauseDetectorThread.start();
            logger.debug(LogMarker.STARTUP.getMarker(), "jvmPauseDetectorThread started");
        }
    }

    public static void writeSettingsUsed(@NonNull Configuration configuration) {
        Objects.requireNonNull(configuration);
        StringBuilder settingsUsedBuilder = new StringBuilder();
        PathsConfig pathsConfig = (PathsConfig)configuration.getConfigData(PathsConfig.class);
        settingsUsedBuilder.append(System.lineSeparator());
        settingsUsedBuilder.append("------------- All Configuration -------------");
        settingsUsedBuilder.append(System.lineSeparator());
        ConfigExport.addConfigContents((Configuration)configuration, (StringBuilder)settingsUsedBuilder);
        Path settingsUsedPath = pathsConfig.getSettingsUsedDir().resolve("settingsUsed.txt");
        try (FileOutputStream outputStream = new FileOutputStream(settingsUsedPath.toFile());){
            ((OutputStream)outputStream).write(settingsUsedBuilder.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException | RuntimeException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to write settingsUsed to file {}", (Object)settingsUsedPath, (Object)e);
        }
    }

    @NonNull
    public static List<NodeId> getNodesToRun(@NonNull Set<NodeId> cliNodesToRun, @NonNull List<NodeId> configNodesToRun, @NonNull Supplier<Set<NodeId>> knownNodeIds, @NonNull Predicate<NodeId> validNodeId) {
        Objects.requireNonNull(validNodeId);
        Objects.requireNonNull(cliNodesToRun);
        Objects.requireNonNull(configNodesToRun);
        Objects.requireNonNull(knownNodeIds);
        ArrayList<NodeId> nodesToRun = new ArrayList<NodeId>();
        if (cliNodesToRun.isEmpty()) {
            if (configNodesToRun.isEmpty()) {
                return new ArrayList<NodeId>((Collection)knownNodeIds.get());
            }
            nodesToRun.addAll(configNodesToRun);
        } else {
            nodesToRun.addAll(cliNodesToRun);
        }
        for (NodeId nodeId : nodesToRun) {
            if (validNodeId.test(nodeId)) continue;
            String errorMessage = "Node " + String.valueOf(nodeId) + " is invalid and cannot be started.";
            logger.error(LogMarker.EXCEPTION.getMarker(), errorMessage);
            SystemExitUtils.exitSystem(SystemExitCode.NODE_ADDRESS_MISMATCH, errorMessage);
            throw new ConfigurationException(errorMessage);
        }
        return nodesToRun;
    }
}

