/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gossip;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.swirlds.platform.crypto.KeyCertPurpose;
import com.swirlds.platform.network.PeerInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.hiero.base.crypto.CryptoUtils;
import org.hiero.consensus.crypto.ConsensusCryptoUtils;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public class Utilities {
    private Utilities() {
    }

    @NonNull
    public static List<PeerInfo> createPeerInfoList(@NonNull Roster roster, @NonNull NodeId selfId) {
        Objects.requireNonNull(roster);
        Objects.requireNonNull(selfId);
        return roster.rosterEntries().stream().filter(entry -> entry.nodeId() != selfId.id()).filter(entry -> CryptoUtils.checkCertificate((Certificate)RosterUtils.fetchGossipCaCertificate((RosterEntry)entry))).map(Utilities::toPeerInfo).toList();
    }

    @NonNull
    public static PeerInfo toPeerInfo(@NonNull RosterEntry entry) {
        Objects.requireNonNull(entry);
        return new PeerInfo(NodeId.of((long)entry.nodeId()), Objects.requireNonNull(RosterUtils.fetchHostname((RosterEntry)entry, (int)0)), RosterUtils.fetchPort((RosterEntry)entry, (int)0), Objects.requireNonNull(RosterUtils.fetchGossipCaCertificate((RosterEntry)entry)));
    }

    @NonNull
    public static KeyStore createPublicKeyStore(@NonNull Collection<PeerInfo> peers) throws KeyStoreException {
        Objects.requireNonNull(peers);
        KeyStore store = ConsensusCryptoUtils.createEmptyTrustStore();
        for (PeerInfo peer : peers) {
            X509Certificate sigCert = peer.signingCertificate();
            store.setCertificateEntry(KeyCertPurpose.SIGNING.storeName(peer.nodeId()), sigCert);
        }
        return store;
    }
}

