/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.hashgraph.internal;

import com.hedera.hapi.platform.event.GossipEvent;
import com.swirlds.platform.gui.BranchedEventMetadata;
import com.swirlds.platform.gui.hashgraph.HashgraphGuiSource;
import com.swirlds.platform.gui.hashgraph.internal.GenerationCoordinates;
import com.swirlds.platform.gui.hashgraph.internal.RosterMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hiero.consensus.hashgraph.impl.EventImpl;

public class PictureMetadata {
    private static final double MARGIN_FRACTION = 0.5;
    private final RosterMetadata rosterMetadata;
    private final int ymax;
    private final int ymin;
    private final int width;
    private final double r;
    private final long minGen;
    private final long maxGen;
    private final HashgraphGuiSource hashgraphSource;
    private final Map<Long, Map<Long, GenerationCoordinates>> nodeIdToGenerationToCoordinates;

    public PictureMetadata(FontMetrics fm, Dimension pictureDimension, RosterMetadata rosterMetadata, List<EventImpl> events, HashgraphGuiSource hashgraphSource, Map<Long, Map<Long, GenerationCoordinates>> nodeIdToGenerationToCoordinates) {
        this.rosterMetadata = rosterMetadata;
        this.hashgraphSource = hashgraphSource;
        this.nodeIdToGenerationToCoordinates = nodeIdToGenerationToCoordinates;
        int fa = fm.getMaxAscent();
        int fd = fm.getMaxDescent();
        int textLineHeight = fa + fd;
        this.width = (int)pictureDimension.getWidth();
        boolean height1 = false;
        int height2 = (int)(pictureDimension.getHeight() - 0.0);
        this.ymin = (int)Math.round(0.0 + 0.025 * (double)height2);
        this.ymax = (int)Math.round(0.0 + 0.975 * (double)height2) - textLineHeight;
        long minGenTmp = Long.MAX_VALUE;
        long maxGenTmp = Long.MIN_VALUE;
        for (EventImpl event : events) {
            minGenTmp = Math.min(minGenTmp, event.getNGen());
            maxGenTmp = Math.max(maxGenTmp, event.getNGen());
        }
        maxGenTmp = Math.max(maxGenTmp, minGenTmp + 2L);
        this.minGen = minGenTmp;
        this.maxGen = maxGenTmp;
        int n = rosterMetadata.getNumMembers() + 1;
        double gens = this.maxGen - this.minGen;
        double dy = (double)(this.ymax - this.ymin) * (gens - 1.0) / gens;
        this.r = Math.min((double)(this.width / n / 4), dy / gens / 2.0);
    }

    public int getGapBetweenColumns() {
        return (int)((double)this.width / ((double)(this.rosterMetadata.getNumColumns() - 1) + 1.0));
    }

    public int getSideGap() {
        return (int)((double)this.getGapBetweenColumns() * 0.5);
    }

    public int xpos(EventImpl e) {
        double marginFraction = 0.5;
        int betweenGap = (int)((double)this.width / ((double)(this.rosterMetadata.getNumColumns() - 1) + 1.0));
        int sideGap = (int)((double)betweenGap * 0.5);
        int xPos = sideGap + this.rosterMetadata.mems2col(e) * betweenGap;
        GossipEvent e2GossipEvent = e.getBaseEvent().getGossipEvent();
        if (this.hashgraphSource.getEventStorage().getBranchedEventsMetadata().containsKey(e2GossipEvent)) {
            return this.calculateXPosForBranchedEvent(e, xPos);
        }
        return xPos;
    }

    public int ypos(EventImpl event) {
        return event == null ? -100 : (int)((double)this.ymax - this.r * (double)(1L + 2L * (event.getNGen() - this.minGen)));
    }

    public int getD() {
        return (int)(2.0 * this.r);
    }

    public int getYmax() {
        return this.ymax;
    }

    public int getYmin() {
        return this.ymin;
    }

    public long getMinGen() {
        return this.minGen;
    }

    private int calculateXPosForBranchedEvent(@NonNull EventImpl event, int currentXPos) {
        int calculatedXPos;
        GossipEvent gossipEvent = event.getBaseEvent().getGossipEvent();
        BranchedEventMetadata branchedEventMetadata = this.hashgraphSource.getEventStorage().getBranchedEventsMetadata().get(gossipEvent);
        Map<Long, GenerationCoordinates> generationToXCoordinates = this.nodeIdToGenerationToCoordinates.get(event.getCreatorId().id());
        GenerationCoordinates coordinatesForGeneration = generationToXCoordinates.computeIfAbsent(branchedEventMetadata.getGeneration(), b -> new GenerationCoordinates());
        Map<GossipEvent, Integer> xCoordinates = coordinatesForGeneration.getXCoordinates();
        if (xCoordinates != null) {
            if (!xCoordinates.containsKey(gossipEvent)) {
                int maxXCoordinateForGeneration = coordinatesForGeneration.getRightMostX();
                calculatedXPos = maxXCoordinateForGeneration + (int)(1.5 * this.r);
                xCoordinates.put(gossipEvent, calculatedXPos);
                coordinatesForGeneration.setRightMostX(calculatedXPos);
            } else {
                calculatedXPos = xCoordinates.get(gossipEvent);
            }
        } else {
            calculatedXPos = currentXPos - (int)(3.0 * this.r / 4.0);
            xCoordinates = new HashMap<GossipEvent, Integer>();
            xCoordinates.put(gossipEvent, calculatedXPos);
            coordinatesForGeneration.setXCoordinates(xCoordinates);
            coordinatesForGeneration.setRightMostX(calculatedXPos);
        }
        return calculatedXPos;
    }
}

