/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantrevokekyc;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.DispatchForResponseCodeHtsCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantrevokekyc.GrantRevokeKycDecoder;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GrantRevokeKycTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod GRANT_KYC = SystemContractMethod.declare("grantTokenKyc(address,address)", "(int64)").withCategories(SystemContractMethod.Category.KYC);
    public static final SystemContractMethod REVOKE_KYC = SystemContractMethod.declare("revokeTokenKyc(address,address)", "(int64)").withCategories(SystemContractMethod.Category.KYC);
    private final GrantRevokeKycDecoder decoder;

    @Inject
    public GrantRevokeKycTranslator(@NonNull GrantRevokeKycDecoder decoder, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.decoder = decoder;
        this.registerMethods(GRANT_KYC, REVOKE_KYC);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(GRANT_KYC, REVOKE_KYC);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        return new DispatchForResponseCodeHtsCall(attempt, this.bodyForClassic(attempt), attempt.isSelector(GRANT_KYC) ? GrantRevokeKycTranslator::grantGasRequirement : GrantRevokeKycTranslator::revokeGasRequirement, DispatchForResponseCodeHtsCall.FailureCustomizer.NOOP_CUSTOMIZER);
    }

    public static long grantGasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.GRANT_KYC, payerId);
    }

    public static long revokeGasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.REVOKE_KYC, payerId);
    }

    private TransactionBody bodyForClassic(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(GRANT_KYC)) {
            return this.decoder.decodeGrantKyc(attempt);
        }
        return this.decoder.decodeRevokeKyc(attempt);
    }
}

