/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.token;

import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.TxnUsageEstimator;
import com.hedera.node.app.hapi.fees.usage.token.TokenOpsUsage;
import com.hedera.node.app.hapi.fees.usage.token.TokenOpsUsageUtils;
import com.hedera.node.app.hapi.fees.usage.token.TokenTxnUsage;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.SubType;
import com.hederahashgraph.api.proto.java.TokenCreateTransactionBody;
import com.hederahashgraph.api.proto.java.TokenType;
import com.hederahashgraph.api.proto.java.TransactionBody;

public class TokenCreateUsage
extends TokenTxnUsage<TokenCreateUsage> {
    private static final TokenOpsUsage tokenOpsUsage = new TokenOpsUsage();

    public TokenCreateUsage(TransactionBody tokenCreationOp, TxnUsageEstimator usageEstimator) {
        super(tokenCreationOp, usageEstimator);
    }

    public static TokenCreateUsage newEstimate(TransactionBody tokenCreationOp, TxnUsageEstimator usageEstimator) {
        return new TokenCreateUsage(tokenCreationOp, usageEstimator);
    }

    @Override
    TokenCreateUsage self() {
        return this;
    }

    public FeeData get() {
        boolean usesCustomFees;
        int baseSize = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.getTokenTxnBaseSize(this.op);
        TokenCreateTransactionBody opTokenCreation = this.op.getTokenCreation();
        long lifetime = opTokenCreation.hasAutoRenewAccount() ? opTokenCreation.getAutoRenewPeriod().getSeconds() : SingletonEstimatorUtils.ESTIMATOR_UTILS.relativeLifetime(this.op, opTokenCreation.getExpiry().getSeconds());
        lifetime = Math.min(lifetime, 3153600000L);
        this.usageEstimator.addBpt(baseSize);
        int feeSchedulesSize = opTokenCreation.getCustomFeesCount() > 0 ? tokenOpsUsage.bytesNeededToRepr(opTokenCreation.getCustomFeesList()) : 0;
        this.usageEstimator.addRbs((long)(baseSize + feeSchedulesSize) * lifetime);
        this.addNetworkRecordRb(24L);
        this.addTokenTransfersRecordRb(1, opTokenCreation.getInitialSupply() > 0L ? 1 : 0, 0);
        boolean bl = usesCustomFees = opTokenCreation.hasFeeScheduleKey() || opTokenCreation.getCustomFeesCount() > 0;
        SubType chosenType = opTokenCreation.getTokenType() == TokenType.NON_FUNGIBLE_UNIQUE ? (usesCustomFees ? SubType.TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES : SubType.TOKEN_NON_FUNGIBLE_UNIQUE) : (usesCustomFees ? SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES : SubType.TOKEN_FUNGIBLE_COMMON);
        return this.usageEstimator.get(chosenType);
    }
}

