/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.istoken;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.istoken.IsTokenTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class IsTokenCall
extends AbstractCall {
    private final boolean isStaticCall;
    @Nullable
    private final Token token;

    public IsTokenCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, boolean isStaticCall, @Nullable Token token) {
        super(gasCalculator, enhancement, true);
        this.isStaticCall = isStaticCall;
        this.token = token;
    }

    @Override
    public boolean allowsStaticFrame() {
        return true;
    }

    @Override
    @NonNull
    public Call.PricedResult execute(MessageFrame frame) {
        return Call.PricedResult.gasOnly(this.fullResultsFor(ResponseCodeEnum.SUCCESS, this.gasCalculator.viewGasRequirement(), this.token != null), ResponseCodeEnum.SUCCESS, true);
    }

    @NonNull
    private FullResult fullResultsFor(@NonNull ResponseCodeEnum status, long gasRequirement, boolean isToken) {
        return FullResult.successResult(IsTokenTranslator.IS_TOKEN.getOutputs().encode((Object)Tuple.of((Object)status.protoOrdinal(), (Object)isToken)), gasRequirement);
    }
}

