/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.api;

import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.StakingNodeInfo;
import com.hedera.node.app.service.token.ReadableStakingInfoStore;
import com.swirlds.common.stream.LinkedObjectStreamUtilities;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface StakingRewardsApi {
    public static final Logger log = LogManager.getLogger(StakingRewardsApi.class);
    public static final int MINUTES_TO_SECONDS = 60;
    public static final long MINUTES_TO_MILLISECONDS = 60000L;
    public static final long DAILY_STAKING_PERIOD_MINS = 1440L;
    public static final ZoneId ZONE_UTC = ZoneId.of("UTC");

    public static long computeRewardFromDetails(@NonNull Account account, @Nullable StakingNodeInfo nodeStakingInfo, long currentStakePeriod, long stakePeriodStart) {
        Objects.requireNonNull(account);
        if (nodeStakingInfo == null || nodeStakingInfo.deleted()) {
            return 0L;
        }
        List rewardSumHistory = nodeStakingInfo.rewardSumHistory();
        return StakingRewardsApi.rewardFor(account, rewardSumHistory, currentStakePeriod, stakePeriodStart);
    }

    public static long estimatePendingReward(int numStoredPeriods, long stakePeriodMins, boolean areRewardsActive, @NonNull Account account, @NonNull ReadableStakingInfoStore readableStakingInfoStore, @NonNull Instant estimatedConsensusNow) {
        if (account.hasStakedNodeId() && !account.declineReward()) {
            long currentStakePeriod = StakingRewardsApi.estimatedCurrentStakePeriod(stakePeriodMins, estimatedConsensusNow);
            long clampedStakePeriodStart = StakingRewardsApi.clampedStakePeriodStart(account.stakePeriodStart(), currentStakePeriod, numStoredPeriods);
            if (StakingRewardsApi.isEstimatedRewardable(stakePeriodMins, clampedStakePeriodStart, areRewardsActive, estimatedConsensusNow)) {
                return StakingRewardsApi.computeRewardFromDetails(account, readableStakingInfoStore.get(account.stakedNodeIdOrThrow()), currentStakePeriod, clampedStakePeriodStart);
            }
        }
        return 0L;
    }

    public static boolean isEstimatedRewardable(long stakePeriodMins, long stakePeriodStart, boolean areRewardsActive, @NonNull Instant estimatedConsensusNow) {
        return stakePeriodStart > -1L && stakePeriodStart < StakingRewardsApi.estimatedFirstNonRewardableStakePeriod(stakePeriodMins, areRewardsActive, estimatedConsensusNow);
    }

    public static long estimatedCurrentStakePeriod(long stakingPeriodMins, @NonNull Instant estimatedConsensusNow) {
        Objects.requireNonNull(estimatedConsensusNow);
        return StakingRewardsApi.stakePeriodAt(estimatedConsensusNow, stakingPeriodMins);
    }

    public static long stakePeriodAt(@NonNull Instant then, long stakePeriodMins) {
        if (stakePeriodMins == 1440L) {
            return LocalDate.ofInstant(then, ZONE_UTC).toEpochDay();
        }
        return LinkedObjectStreamUtilities.getPeriod((Instant)then, (long)(stakePeriodMins * 60000L));
    }

    public static long epochSecondAtStartOfPeriod(long stakePeriod, long stakePeriodMins) {
        if (stakePeriodMins == 1440L) {
            return LocalDate.ofEpochDay(stakePeriod).atStartOfDay().toEpochSecond(ZoneOffset.UTC);
        }
        return stakePeriod * stakePeriodMins * 60L;
    }

    public static long clampedStakePeriodStart(long stakePeriodStart, long currentStakePeriod, int numStoredPeriods) {
        if (stakePeriodStart > -1L && stakePeriodStart < currentStakePeriod - (long)numStoredPeriods) {
            return currentStakePeriod - (long)numStoredPeriods - 1L;
        }
        return stakePeriodStart;
    }

    private static long rewardFor(@NonNull Account account, @NonNull List<Long> rewardSumHistory, long currentStakePeriod, long effectiveStart) {
        int rewardFrom = (int)(currentStakePeriod - 1L - effectiveStart);
        if (rewardFrom <= 0) {
            return 0L;
        }
        Long firstRewardSum = rewardSumHistory.getFirst();
        Long rewardFromSum = rewardSumHistory.get(rewardFrom);
        if (account.stakeAtStartOfLastRewardedPeriod() != -1L) {
            Long rewardFromMinus1Sum = rewardSumHistory.get(rewardFrom - 1);
            return account.stakeAtStartOfLastRewardedPeriod() / 100000000L * (rewardFromMinus1Sum - rewardFromSum) + StakingRewardsApi.totalStake(account) / 100000000L * (firstRewardSum - rewardFromMinus1Sum);
        }
        return StakingRewardsApi.totalStake(account) / 100000000L * (firstRewardSum - rewardFromSum);
    }

    private static long totalStake(@NonNull Account account) {
        return account.tinybarBalance() + account.stakedToMe();
    }

    private static long estimatedFirstNonRewardableStakePeriod(long stakingPeriodMins, boolean stakingRewardsActive, @NonNull Instant estimatedConsensusNow) {
        return stakingRewardsActive ? StakingRewardsApi.estimatedCurrentStakePeriod(stakingPeriodMins, estimatedConsensusNow) - 1L : Long.MIN_VALUE;
    }
}

