/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ThreeLongsList {
    private static final int LONGS_PER_TRIPLE = 3;
    private static final int SECOND_LONG_OFFSET = 1;
    private static final int THIRD_LONG_OFFSET = 2;
    public static final int SMALL_MAX_TRIPLES = 4000;
    public static final int SMALL_TRIPLES_PER_CHUNK = 1000;
    private final int maxTriples;
    private final int triplesPerChunk;
    private final List<long[]> data = new ArrayList<long[]>();
    private int numChunks = 0;
    private int nextIndex = 0;

    public ThreeLongsList() {
        this(4000, 1000);
    }

    public ThreeLongsList(int maxTriples) {
        this(maxTriples, Math.min(maxTriples, 1000));
    }

    public ThreeLongsList(int maxTriples, int triplesPerChunk) {
        if (triplesPerChunk < 1 || maxTriples < triplesPerChunk) {
            throw new IllegalArgumentException("Cannot construct ThreeLongsList with " + maxTriples + " max triples and " + triplesPerChunk + " triples per chunk");
        }
        this.maxTriples = maxTriples;
        this.triplesPerChunk = triplesPerChunk;
    }

    public void add(long l1, long l2, long l3) {
        if (this.nextIndex == this.maxTriples) {
            throw new IllegalStateException("Cannot store any more triples, reached max capacity of " + this.maxTriples);
        }
        int chunkIndex = this.nextIndex / this.triplesPerChunk;
        int subIndex = this.nextIndex % this.triplesPerChunk;
        if (subIndex == 0 && this.numChunks == chunkIndex) {
            long[] nextChunk = new long[3 * this.triplesPerChunk];
            this.data.add(nextChunk);
            ++this.numChunks;
        }
        long[] chunk = this.data.get(chunkIndex);
        chunk[subIndex *= 3] = l1;
        chunk[subIndex + 1] = l2;
        chunk[subIndex + 2] = l3;
        ++this.nextIndex;
    }

    public long[] get(int index) {
        if (index < 0 || index >= this.nextIndex) {
            throw new IndexOutOfBoundsException("Index " + index + " unusable with " + this.nextIndex + " triples stored");
        }
        int chunkIndex = index / this.triplesPerChunk;
        long[] chunk = this.data.get(chunkIndex);
        int subIndex = index % this.triplesPerChunk * 3;
        return Arrays.copyOfRange(chunk, subIndex, subIndex + 3);
    }

    public void clear() {
        this.nextIndex = 0;
    }

    public <T extends Throwable> void forEach(ThreeLongFunction<T> handler) throws T {
        int index = 0;
        for (long[] chunk : this.data) {
            int j = 0;
            int k = 0;
            while (j < this.triplesPerChunk) {
                if (index == this.nextIndex) {
                    return;
                }
                handler.process(chunk[k], chunk[k + 1], chunk[k + 2]);
                ++index;
                ++j;
                k += 3;
            }
        }
    }

    public int size() {
        return this.nextIndex;
    }

    public int capacity() {
        return this.maxTriples;
    }

    int getTriplesPerChunk() {
        return this.triplesPerChunk;
    }

    @FunctionalInterface
    public static interface ThreeLongFunction<T extends Throwable> {
        public void process(long var1, long var3, long var5) throws T;
    }
}

