/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.eventhandling;

import com.swirlds.component.framework.schedulers.builders.TaskSchedulerConfiguration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.ToLongFunction;
import org.hiero.consensus.model.hashgraph.ConsensusRound;

public class TransactionHandlerDataCounter
implements ToLongFunction<Object> {
    private static final int LOW_TPS_TARGET_ROUNDS = 25;
    private final double minimumEffort;

    public TransactionHandlerDataCounter(long roundMaxTransactionCapacity, double targetMaxRounds) {
        this.minimumEffort = (double)roundMaxTransactionCapacity / targetMaxRounds;
    }

    @Override
    public long applyAsLong(Object data) {
        if (data instanceof ConsensusRound) {
            ConsensusRound consensusRound = (ConsensusRound)data;
            return (long)Math.max(this.minimumEffort, (double)consensusRound.getNumAppTransactions());
        }
        return 1L;
    }

    @NonNull
    public static TransactionHandlerDataCounter create(@NonNull TaskSchedulerConfiguration schedulerConfiguration) {
        long capacity = Objects.requireNonNull(schedulerConfiguration).unhandledTaskCapacity() == null ? 0L : schedulerConfiguration.unhandledTaskCapacity();
        return new TransactionHandlerDataCounter(capacity, 25.0);
    }
}

