/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.platform.event.GossipEvent;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.gui.BranchedEventMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hiero.consensus.hashgraph.config.ConsensusConfig;
import org.hiero.consensus.hashgraph.impl.EventImpl;
import org.hiero.consensus.hashgraph.impl.consensus.Consensus;
import org.hiero.consensus.hashgraph.impl.consensus.ConsensusImpl;
import org.hiero.consensus.hashgraph.impl.linking.ConsensusLinker;
import org.hiero.consensus.hashgraph.impl.linking.NoOpLinkerLogsAndMetrics;
import org.hiero.consensus.hashgraph.impl.metrics.ConsensusMetrics;
import org.hiero.consensus.hashgraph.impl.metrics.NoOpConsensusMetrics;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.round.EventWindowUtils;

public class GuiEventStorage {
    private long maxGeneration = 0L;
    private final Consensus consensus;
    private final ConsensusLinker linker;
    private final Configuration configuration;
    private ConsensusRound lastConsensusRound;
    private Map<GossipEvent, BranchedEventMetadata> branchedEventsMetadata = new HashMap<GossipEvent, BranchedEventMetadata>();

    public GuiEventStorage(@NonNull Configuration configuration, @NonNull Roster roster) {
        this.configuration = Objects.requireNonNull(configuration);
        PlatformContext platformContext = PlatformContext.create((Configuration)configuration);
        this.consensus = new ConsensusImpl(platformContext.getConfiguration(), platformContext.getTime(), (ConsensusMetrics)new NoOpConsensusMetrics(), roster);
        this.linker = new ConsensusLinker(NoOpLinkerLogsAndMetrics.getInstance());
    }

    public GuiEventStorage(@NonNull Consensus consensus, @NonNull ConsensusLinker linker, @NonNull Configuration configuration) {
        this.consensus = consensus;
        this.linker = linker;
        this.configuration = configuration;
        this.maxGeneration = linker.getNonAncientEvents().stream().mapToLong(EventImpl::getNGen).max().orElse(0L);
    }

    @NonNull
    public Consensus getConsensus() {
        return this.consensus;
    }

    public synchronized void handlePreconsensusEvent(@NonNull PlatformEvent event) {
        this.maxGeneration = Math.max(this.maxGeneration, event.getNGen());
        EventImpl eventImpl = this.linker.linkEvent(event.copyGossipedData());
        if (eventImpl == null) {
            return;
        }
        eventImpl.getBaseEvent().setNGen(event.getNGen());
        List rounds = this.consensus.addEvent(eventImpl);
        if (rounds.isEmpty()) {
            return;
        }
        this.lastConsensusRound = (ConsensusRound)rounds.getLast();
        this.linker.setEventWindow(((ConsensusRound)rounds.getLast()).getEventWindow());
    }

    public synchronized void handleSnapshotOverride(@NonNull ConsensusSnapshot snapshot) {
        this.consensus.loadSnapshot(snapshot);
        this.linker.clear();
        this.linker.setEventWindow(EventWindowUtils.createEventWindow((ConsensusSnapshot)snapshot, (int)((ConsensusConfig)this.configuration.getConfigData(ConsensusConfig.class)).roundsNonAncient()));
        this.lastConsensusRound = null;
    }

    public synchronized long getMaxGeneration() {
        return this.maxGeneration;
    }

    @NonNull
    public synchronized List<EventImpl> getNonAncientEvents() {
        return this.linker.getNonAncientEvents();
    }

    @Nullable
    public synchronized ConsensusRound getLastConsensusRound() {
        return this.lastConsensusRound;
    }

    @NonNull
    public Map<GossipEvent, BranchedEventMetadata> getBranchedEventsMetadata() {
        return this.branchedEventsMetadata;
    }

    public void setBranchedEventsMetadata(@NonNull Map<GossipEvent, BranchedEventMetadata> branchedEventsMetadata) {
        this.branchedEventsMetadata = branchedEventsMetadata;
    }
}

