/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.hashgraph.internal;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.platform.gui.GuiEventStorage;
import com.swirlds.platform.gui.hashgraph.HashgraphGuiSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import org.hiero.consensus.hashgraph.impl.EventImpl;

public class CachingGuiSource
implements HashgraphGuiSource {
    private final HashgraphGuiSource source;
    private List<EventImpl> events = null;
    private Roster roster = null;
    private final GuiEventStorage eventStorage;
    private long maxGeneration = -1L;
    private long startGeneration = 0L;
    private int numGenerations = 25;

    public CachingGuiSource(HashgraphGuiSource source) {
        this.source = source;
        this.eventStorage = source.getEventStorage();
    }

    @Override
    public long getMaxGeneration() {
        return this.maxGeneration;
    }

    @Override
    @NonNull
    public List<EventImpl> getEvents(long startGeneration, int numGenerations) {
        this.startGeneration = startGeneration;
        this.numGenerations = numGenerations;
        return this.events;
    }

    @Override
    @NonNull
    public Roster getRoster() {
        return this.roster;
    }

    @Override
    public boolean isReady() {
        return this.events != null && this.roster != null && this.maxGeneration != -1L;
    }

    @Override
    public GuiEventStorage getEventStorage() {
        return this.eventStorage;
    }

    public void refresh() {
        if (this.source.isReady()) {
            this.events = this.source.getEvents(this.startGeneration, this.numGenerations);
            this.roster = this.source.getRoster();
            this.maxGeneration = this.source.getMaxGeneration();
        }
    }
}

