/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.schedulers.internal;

import com.swirlds.component.framework.counters.ObjectCounter;
import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.schedulers.internal.SequentialTask;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.hiero.consensus.metrics.extensions.FractionalTimer;

public class SequentialTaskScheduler<OUT>
extends TaskScheduler<OUT> {
    private final AtomicReference<SequentialTask> nextTaskPlaceholder;
    private final ObjectCounter onRamp;
    private final ObjectCounter offRamp;
    private final FractionalTimer busyTimer;
    private final ForkJoinPool pool;
    private final long capacity;

    public SequentialTaskScheduler(@NonNull TraceableWiringModel model, @NonNull String name, @NonNull ForkJoinPool pool, @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler, @NonNull ObjectCounter onRamp, @NonNull ObjectCounter offRamp, @NonNull FractionalTimer busyTimer, long capacity, boolean flushEnabled, boolean squelchingEnabled, boolean insertionIsBlocking) {
        super(model, name, TaskSchedulerType.SEQUENTIAL, uncaughtExceptionHandler, flushEnabled, squelchingEnabled, insertionIsBlocking);
        this.pool = Objects.requireNonNull(pool);
        this.onRamp = Objects.requireNonNull(onRamp);
        this.offRamp = Objects.requireNonNull(offRamp);
        this.busyTimer = Objects.requireNonNull(busyTimer);
        this.capacity = capacity;
        this.nextTaskPlaceholder = new AtomicReference<SequentialTask>(new SequentialTask(pool, offRamp, busyTimer, uncaughtExceptionHandler, true));
    }

    @Override
    protected void put(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.onRamp.onRamp();
        this.scheduleTask(handler, data);
    }

    @Override
    protected boolean offer(@NonNull Consumer<Object> handler, @NonNull Object data) {
        boolean accepted = this.onRamp.attemptOnRamp();
        if (accepted) {
            this.scheduleTask(handler, data);
        }
        return accepted;
    }

    @Override
    protected void inject(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.onRamp.forceOnRamp();
        this.scheduleTask(handler, data);
    }

    private void scheduleTask(@NonNull Consumer<Object> handler, @NonNull Object data) {
        SequentialTask currentTask;
        SequentialTask nextTask = new SequentialTask(this.pool, this.offRamp, this.busyTimer, this.getUncaughtExceptionHandler(), false);
        while (!this.nextTaskPlaceholder.compareAndSet(currentTask = this.nextTaskPlaceholder.get(), nextTask)) {
        }
        currentTask.send(nextTask, handler, data);
    }

    @Override
    public long getUnprocessedTaskCount() {
        return this.onRamp.getCount();
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public void flush() {
        this.throwIfFlushDisabled();
        this.onRamp.waitUntilEmpty();
    }
}

