/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.concurrency.limits;

import io.helidon.common.concurrency.limits.LimitAlgorithm;
import io.helidon.common.concurrency.limits.NoopSemaphore;
import io.helidon.common.concurrency.limits.SemaphoreLimit;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

class LimitHandlers {
    private LimitHandlers() {
    }

    static class QueuedSemaphoreHandler
    implements LimiterHandler {
        private final Semaphore semaphore;
        private final int queueLength;
        private final long timeoutMillis;
        private final Supplier<LimitAlgorithm.Token> tokenSupplier;

        QueuedSemaphoreHandler(Semaphore semaphore, int queueLength, Duration queueTimeout, Supplier<LimitAlgorithm.Token> tokenSupplier) {
            this.semaphore = semaphore;
            this.queueLength = queueLength;
            this.timeoutMillis = queueTimeout.toMillis();
            this.tokenSupplier = tokenSupplier;
        }

        @Override
        public Optional<LimitAlgorithm.Token> tryAcquireToken(boolean wait) {
            if (this.queueLength > 0 && this.semaphore.getQueueLength() >= this.queueLength) {
                return Optional.empty();
            }
            try {
                if (wait ? !this.semaphore.tryAcquire(this.timeoutMillis, TimeUnit.MILLISECONDS) : !this.semaphore.tryAcquire()) {
                    return Optional.empty();
                }
            }
            catch (InterruptedException e) {
                return Optional.empty();
            }
            return Optional.of(this.tokenSupplier.get());
        }

        @Override
        public Semaphore semaphore() {
            return this.semaphore;
        }
    }

    static class NoOpSemaphoreHandler
    implements LimiterHandler {
        private static final LimitAlgorithm.Token TOKEN = new LimitAlgorithm.Token(){

            @Override
            public void dropped() {
            }

            @Override
            public void ignore() {
            }

            @Override
            public void success() {
            }
        };

        NoOpSemaphoreHandler() {
        }

        @Override
        public Optional<LimitAlgorithm.Token> tryAcquireToken(boolean wait) {
            return Optional.of(TOKEN);
        }

        @Override
        public Semaphore semaphore() {
            return NoopSemaphore.INSTANCE;
        }
    }

    static interface LimiterHandler
    extends SemaphoreLimit {
        public Optional<LimitAlgorithm.Token> tryAcquireToken(boolean var1);
    }
}

