/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.hapi.fees;

import com.hedera.node.app.hapi.utils.CommonUtils;
import java.util.ArrayList;
import java.util.List;

public class FeeResult {
    private long serviceBase = 0L;
    private List<FeeDetail> serviceExtrasDetails = new ArrayList<FeeDetail>();
    private long serviceTotal = 0L;
    private long nodeBase = 0L;
    private List<FeeDetail> nodeExtrasDetails = new ArrayList<FeeDetail>();
    private long nodeTotal = 0L;
    private int networkMultiplier = 0;
    private int congestionMultiplier = 0;

    public FeeResult() {
    }

    public FeeResult(long serviceTotal, long nodeTotal, int networkMultiplier) {
        this.serviceTotal = serviceTotal;
        this.nodeTotal = nodeTotal;
        this.networkMultiplier = networkMultiplier;
    }

    public long getServiceTotalTinycents() {
        return this.serviceTotal;
    }

    public void setServiceBaseFeeTinycents(long cost) {
        this.serviceBase = cost;
        this.serviceTotal = CommonUtils.clampedAdd((long)this.serviceTotal, (long)cost);
    }

    public long getServiceBaseFeeTinycents() {
        return this.serviceBase;
    }

    public void addServiceExtraFeeTinycents(String name, long unitCost, long used, long included) {
        long charged = Math.max(0L, used - included);
        if (charged > 0L) {
            this.serviceExtrasDetails.add(new FeeDetail(name, unitCost, used, included, charged));
            this.serviceTotal = CommonUtils.clampedAdd((long)this.serviceTotal, (long)CommonUtils.clampedMultiply((long)unitCost, (long)charged));
        }
    }

    public List<FeeDetail> getServiceExtraDetails() {
        return this.serviceExtrasDetails;
    }

    public long getNodeTotalTinycents() {
        return this.nodeTotal;
    }

    public void setNodeBaseFeeTinycents(long cost) {
        this.nodeBase = cost;
        this.nodeTotal = CommonUtils.clampedAdd((long)this.nodeTotal, (long)cost);
    }

    public long getNodeBaseFeeTinycents() {
        return this.nodeBase;
    }

    public void addNodeExtraFeeTinycents(String name, long unitCost, long used, long included) {
        long charged = Math.max(0L, used - included);
        if (charged > 0L) {
            this.nodeExtrasDetails.add(new FeeDetail(name, unitCost, used, included, charged));
            this.nodeTotal = CommonUtils.clampedAdd((long)this.nodeTotal, (long)CommonUtils.clampedMultiply((long)unitCost, (long)charged));
        }
    }

    public List<FeeDetail> getNodeExtraDetails() {
        return this.nodeExtrasDetails;
    }

    public void setNetworkMultiplier(int networkMultiplier) {
        this.networkMultiplier = networkMultiplier;
    }

    public int getNetworkMultiplier() {
        return this.networkMultiplier;
    }

    public long getNetworkTotalTinycents() {
        return CommonUtils.clampedMultiply((long)this.getNodeTotalTinycents(), (long)this.networkMultiplier);
    }

    public void clearFees() {
        this.serviceExtrasDetails.clear();
        this.serviceBase = 0L;
        this.serviceTotal = 0L;
        this.nodeExtrasDetails.clear();
        this.nodeBase = 0L;
        this.nodeTotal = 0L;
        this.networkMultiplier = 0;
        this.congestionMultiplier = 0;
    }

    public long totalTinycents() {
        return CommonUtils.clampedAdd((long)CommonUtils.clampedAdd((long)this.getNodeTotalTinycents(), (long)this.getNetworkTotalTinycents()), (long)this.getServiceTotalTinycents());
    }

    public String toString() {
        return "FeeResult{fee=" + this.totalTinycents() + ", details=" + String.valueOf(this.getServiceExtraDetails()) + "}";
    }

    public record FeeDetail(String name, long perUnit, long used, long included, long charged) {
    }
}

