/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.server.impl;

import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.identityconnectors.common.l10n.CurrentLocale;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.api.APIConfiguration;
import org.identityconnectors.framework.api.ConnectorFacade;
import org.identityconnectors.framework.api.ConnectorFacadeFactory;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.api.ConnectorInfoManager;
import org.identityconnectors.framework.api.ConnectorInfoManagerFactory;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidCredentialException;
import org.identityconnectors.framework.common.serializer.SerializerUtil;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.AbstractConnectorInfo;
import org.identityconnectors.framework.impl.api.ConnectorInfoManagerFactoryImpl;
import org.identityconnectors.framework.impl.api.ObjectStreamHandler;
import org.identityconnectors.framework.impl.api.StreamHandlerUtil;
import org.identityconnectors.framework.impl.api.local.LocalConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.remote.RemoteConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.remote.RemoteFrameworkConnection;
import org.identityconnectors.framework.impl.api.remote.messages.EchoMessage;
import org.identityconnectors.framework.impl.api.remote.messages.HelloRequest;
import org.identityconnectors.framework.impl.api.remote.messages.HelloResponse;
import org.identityconnectors.framework.impl.api.remote.messages.OperationRequest;
import org.identityconnectors.framework.impl.api.remote.messages.OperationRequestMoreData;
import org.identityconnectors.framework.impl.api.remote.messages.OperationResponseEnd;
import org.identityconnectors.framework.impl.api.remote.messages.OperationResponsePart;
import org.identityconnectors.framework.impl.api.remote.messages.OperationResponsePause;
import org.identityconnectors.framework.server.ConnectorServer;
import org.identityconnectors.framework.server.impl.ConnectionListener;

public class ConnectionProcessor
implements Runnable {
    private static final Log _log = Log.getLog(ConnectionListener.class);
    private final ConnectorServer _server;
    private final RemoteFrameworkConnection _connection;

    public ConnectionProcessor(ConnectorServer server, Socket socket) {
        this._server = server;
        this._connection = new RemoteFrameworkConnection(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                boolean keepGoing;
                while (keepGoing = this.processRequest()) {
                }
            }
            finally {
                try {
                    this._connection.close();
                }
                catch (Exception e) {
                    _log.error((Throwable)e, null, new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            _log.error(e, null, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processRequest() throws Exception {
        Object requestObject;
        boolean authorized;
        Locale locale;
        try {
            locale = (Locale)this._connection.readObject();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof EOFException) {
                return false;
            }
            throw e;
        }
        CurrentLocale.set((Locale)locale);
        GuardedString key = (GuardedString)this._connection.readObject();
        try {
            authorized = key.verifyBase64SHA1Hash(this._server.getKeyHash());
        }
        finally {
            key.dispose();
        }
        InvalidCredentialException authException = null;
        if (!authorized) {
            authException = new InvalidCredentialException("Remote framework key is invalid");
        }
        if ((requestObject = this._connection.readObject()) instanceof HelloRequest) {
            if (authException != null) {
                HelloResponse response = new HelloResponse((Throwable)authException, null);
                this._connection.writeObject(response);
            } else {
                HelloResponse response = this.processHelloRequest((HelloRequest)requestObject);
                this._connection.writeObject(response);
            }
        } else if (requestObject instanceof OperationRequest) {
            if (authException != null) {
                OperationResponsePart part = new OperationResponsePart((Throwable)authException, null);
                this._connection.writeObject(part);
            } else {
                OperationRequest opRequest = (OperationRequest)requestObject;
                OperationResponsePart part = this.processOperationRequest(opRequest);
                this._connection.writeObject(part);
            }
        } else if (requestObject instanceof EchoMessage) {
            if (authException != null) {
                EchoMessage part = new EchoMessage(authException, null);
                this._connection.writeObject(part);
            } else {
                EchoMessage message = (EchoMessage)requestObject;
                Object obj = message.getObject();
                String xml = message.getXml();
                if (xml != null) {
                    Object xmlClone = SerializerUtil.deserializeXmlObject((String)xml, (boolean)true);
                    xml = SerializerUtil.serializeXmlObject((Object)xmlClone, (boolean)true);
                }
                EchoMessage message2 = new EchoMessage(obj, xml);
                this._connection.writeObject(message2);
            }
        } else {
            throw new ConnectorException("Unexpected request: " + requestObject);
        }
        return true;
    }

    private ConnectorInfoManager getConnectorInfoManager() {
        ConnectorInfoManagerFactoryImpl factory = (ConnectorInfoManagerFactoryImpl)ConnectorInfoManagerFactory.getInstance();
        return factory.getLocalManager(this._server.getBundleURLs(), this._server.getBundleParentClassLoader());
    }

    private HelloResponse processHelloRequest(HelloRequest request) {
        ArrayList<RemoteConnectorInfoImpl> connectorInfo;
        Exception exception = null;
        try {
            ConnectorInfoManager manager = this.getConnectorInfoManager();
            List localInfos = manager.getConnectorInfos();
            connectorInfo = new ArrayList<RemoteConnectorInfoImpl>();
            for (ConnectorInfo localInfo : localInfos) {
                LocalConnectorInfoImpl localInfoImpl = (LocalConnectorInfoImpl)localInfo;
                RemoteConnectorInfoImpl remoteInfo = localInfoImpl.toRemote();
                connectorInfo.add(remoteInfo);
            }
        }
        catch (Exception e) {
            exception = e;
            connectorInfo = null;
        }
        return new HelloResponse(exception, connectorInfo);
    }

    private Method getOperationMethod(OperationRequest request) {
        Method[] methods = request.getOperation().getDeclaredMethods();
        Method found = null;
        for (Method m : methods) {
            if (!m.getName().equalsIgnoreCase(request.getOperationMethodName())) continue;
            if (found != null) {
                throw new ConnectorException("APIOperations are expected to have exactly one method of a given name: " + request.getOperation());
            }
            found = m;
        }
        if (found == null) {
            throw new ConnectorException("APIOperations are expected to have exactly one method of a given name: " + request.getOperation());
        }
        return found;
    }

    private OperationResponsePart processOperationRequest(OperationRequest request) throws IOException {
        Object result;
        Throwable exception;
        block8: {
            exception = null;
            try {
                boolean anyStreams;
                Method method = this.getOperationMethod(request);
                APIOperation operation = this.getAPIOperation(request);
                List<Object> arguments = request.getArguments();
                List<Object> argumentsAndStreamHandlers = this.populateStreamHandlers(method.getParameterTypes(), arguments);
                try {
                    result = method.invoke((Object)operation, argumentsAndStreamHandlers.toArray());
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
                boolean bl = anyStreams = argumentsAndStreamHandlers.size() > arguments.size();
                if (!anyStreams) break block8;
                try {
                    this._connection.writeObject(new OperationResponseEnd());
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof IOException) {
                        throw new BrokenConnectionException((IOException)e.getCause());
                    }
                    throw e;
                }
            }
            catch (BrokenConnectionException w) {
                throw w.getIOException();
            }
            catch (Throwable e) {
                _log.error(e, null, new Object[0]);
                exception = e;
                result = null;
            }
        }
        return new OperationResponsePart(exception, result);
    }

    private List<Object> populateStreamHandlers(Class<?>[] paramTypes, List<Object> arguments) {
        ArrayList<Object> rv = new ArrayList<Object>();
        boolean firstStream = true;
        Iterator<Object> argIt = arguments.iterator();
        for (Class<?> paramType : paramTypes) {
            if (StreamHandlerUtil.isAdaptableToObjectStreamHandler(paramType)) {
                if (!firstStream) {
                    throw new UnsupportedOperationException("At most one stream handler is supported");
                }
                RemoteResultsHandler osh = new RemoteResultsHandler(this._connection);
                rv.add(StreamHandlerUtil.adaptFromObjectStreamHandler(paramType, osh));
                firstStream = false;
                continue;
            }
            rv.add(argIt.next());
        }
        return rv;
    }

    private APIOperation getAPIOperation(OperationRequest request) throws Exception {
        ConnectorInfoManager manager = this.getConnectorInfoManager();
        ConnectorInfo info = manager.findConnectorInfo(request.getConnectorKey());
        if (info == null) {
            throw new ConnectorException("No such connector: " + request.getConnectorKey() + " ");
        }
        APIConfigurationImpl config = request.getConfiguration();
        config.setConnectorInfo((AbstractConnectorInfo)info);
        ConnectorFacade facade = ConnectorFacadeFactory.getInstance().newInstance((APIConfiguration)config);
        return facade.getOperation(request.getOperation());
    }

    private static class BrokenConnectionException
    extends ConnectorException {
        static final long serialVersionUID = 0L;

        public BrokenConnectionException(IOException ex) {
            super((Throwable)ex);
        }

        public IOException getIOException() {
            return (IOException)this.getCause();
        }
    }

    private static class RemoteResultsHandler
    implements ObjectStreamHandler {
        private static final int PAUSE_INTERVAL = 200;
        private final RemoteFrameworkConnection _connection;
        private long _count = 0L;

        public RemoteResultsHandler(RemoteFrameworkConnection conn) {
            this._connection = conn;
        }

        @Override
        public boolean handle(Object obj) {
            try {
                OperationResponsePart part = new OperationResponsePart(null, obj);
                this._connection.writeObject(part);
                ++this._count;
                if (this._count % 200L == 0L) {
                    this._connection.writeObject(new OperationResponsePause());
                    Object message = this._connection.readObject();
                    return message instanceof OperationRequestMoreData;
                }
                return true;
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw new BrokenConnectionException((IOException)e.getCause());
                }
                throw e;
            }
        }
    }
}

