/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees;

import com.hedera.hapi.node.base.CurrentAndNextFeeSchedule;
import com.hedera.hapi.node.base.FeeComponents;
import com.hedera.hapi.node.base.FeeData;
import com.hedera.hapi.node.base.FeeSchedule;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TransactionFeeSchedule;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.fees.ExchangeRateManager;
import com.hedera.node.app.fees.FeeCalculatorImpl;
import com.hedera.node.app.fees.NoOpFeeCalculator;
import com.hedera.node.app.fees.SimpleFeeCalculatorImpl;
import com.hedera.node.app.fees.congestion.CongestionMultipliers;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.QueryFeeCalculator;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeCalculator;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.BufferUnderflowException;
import java.time.Instant;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.hapi.fees.FeeScheduleUtils;

@Singleton
public final class FeeManager {
    private static final Logger logger = LogManager.getLogger(FeeManager.class);
    private org.hiero.hapi.support.fees.FeeSchedule simpleFeesSchedule;
    @Nullable
    private SimpleFeeCalculator simpleFeeCalculator;
    private final Set<ServiceFeeCalculator> serviceFeeCalculators;
    private final Set<QueryFeeCalculator> queryFeeCalculators;
    private static final long DEFAULT_FEE = 100000L;
    private static final Set<HederaFunctionality> INAPPLICABLE_OPERATIONS = EnumSet.of(HederaFunctionality.FREEZE, new HederaFunctionality[]{HederaFunctionality.GET_ACCOUNT_DETAILS, HederaFunctionality.NETWORK_GET_EXECUTION_TIME, HederaFunctionality.TRANSACTION_GET_FAST_RECORD, HederaFunctionality.TOKEN_GET_NFT_INFOS, HederaFunctionality.TOKEN_GET_ACCOUNT_NFT_INFOS});
    private static final FeeComponents DEFAULT_FEE_COMPONENTS = FeeComponents.newBuilder().min(100000L).max(100000L).build();
    private static final FeeData DEFAULT_FEE_DATA = FeeData.newBuilder().networkdata(DEFAULT_FEE_COMPONENTS).nodedata(DEFAULT_FEE_COMPONENTS).servicedata(DEFAULT_FEE_COMPONENTS).build();
    private Map<Entry, FeeData> currentFeeDataMap = Collections.emptyMap();
    private Map<Entry, FeeData> nextFeeDataMap = Collections.emptyMap();
    private long currentScheduleExpirationSeconds;
    private final ExchangeRateManager exchangeRateManager;
    private final CongestionMultipliers congestionMultipliers;

    @Inject
    public FeeManager(@NonNull ExchangeRateManager exchangeRateManager, @NonNull CongestionMultipliers congestionMultipliers, @NonNull Set<ServiceFeeCalculator> serviceFeeCalculators, @NonNull Set<QueryFeeCalculator> queryFeeCalculators) {
        this.exchangeRateManager = Objects.requireNonNull(exchangeRateManager);
        this.congestionMultipliers = Objects.requireNonNull(congestionMultipliers);
        this.serviceFeeCalculators = Objects.requireNonNull(serviceFeeCalculators);
        this.queryFeeCalculators = Objects.requireNonNull(queryFeeCalculators);
    }

    public ResponseCodeEnum update(@NonNull Bytes bytes) {
        CurrentAndNextFeeSchedule schedules;
        try {
            schedules = (CurrentAndNextFeeSchedule)CurrentAndNextFeeSchedule.PROTOBUF.parse(bytes.toReadableSequentialData());
        }
        catch (ParseException | BufferUnderflowException ex) {
            return ResponseCodeEnum.FEE_SCHEDULE_FILE_PART_UPLOADED;
        }
        FeeSchedule currentSchedule = schedules.currentFeeSchedule();
        if (currentSchedule == null) {
            logger.warn("Unable to parse current fee schedule, will default to an empty schedule, effectivelydisabling all transactions.");
            currentSchedule = FeeSchedule.DEFAULT;
        }
        HashMap<Entry, FeeData> newCurrentFeeDataMap = new HashMap<Entry, FeeData>();
        this.populateFeeDataMap(newCurrentFeeDataMap, currentSchedule.transactionFeeSchedule());
        this.currentFeeDataMap = newCurrentFeeDataMap;
        if (currentSchedule.hasExpiryTime()) {
            this.currentScheduleExpirationSeconds = currentSchedule.expiryTimeOrThrow().seconds();
        } else {
            logger.warn("The current fee schedule has no expiry time, defaulting to 0, effectively expiring it immediately");
            this.currentScheduleExpirationSeconds = 0L;
        }
        FeeSchedule nextSchedule = schedules.nextFeeSchedule();
        if (nextSchedule == null) {
            logger.warn("Unable to parse next fee schedule, will default to the current fee schedule.");
            this.nextFeeDataMap = new HashMap<Entry, FeeData>(this.currentFeeDataMap);
        } else {
            HashMap<Entry, FeeData> newNextFeeDataMap = new HashMap<Entry, FeeData>();
            this.populateFeeDataMap(newNextFeeDataMap, nextSchedule.transactionFeeSchedule());
            this.nextFeeDataMap = newNextFeeDataMap;
        }
        return ResponseCodeEnum.SUCCESS;
    }

    public ResponseCodeEnum updateSimpleFees(@NonNull Bytes bytes) {
        try {
            org.hiero.hapi.support.fees.FeeSchedule schedule = (org.hiero.hapi.support.fees.FeeSchedule)org.hiero.hapi.support.fees.FeeSchedule.PROTOBUF.parse(bytes);
            if (FeeScheduleUtils.isValid((org.hiero.hapi.support.fees.FeeSchedule)schedule)) {
                this.simpleFeesSchedule = schedule;
                this.simpleFeeCalculator = new SimpleFeeCalculatorImpl(schedule, this.serviceFeeCalculators, this.queryFeeCalculators);
                return ResponseCodeEnum.SUCCESS;
            }
            logger.error("Unable to validate simple fee schedule.");
            return ResponseCodeEnum.FEE_SCHEDULE_FILE_PART_UPLOADED;
        }
        catch (ParseException | BufferUnderflowException ex) {
            return ResponseCodeEnum.FEE_SCHEDULE_FILE_PART_UPLOADED;
        }
    }

    @NonNull
    public FeeCalculator createFeeCalculator(@Nullable TransactionBody txBody, @Nullable Key payerKey, @Nullable HederaFunctionality functionality, int numVerifications, int signatureMapSize, @NonNull Instant consensusTime, @NonNull SubType subType, boolean isInternalDispatch, ReadableStoreFactory storeFactory) {
        if (txBody == null || payerKey == null || functionality == null) {
            return NoOpFeeCalculator.INSTANCE;
        }
        functionality = functionality == HederaFunctionality.HOOK_STORE ? HederaFunctionality.CONTRACT_CALL : functionality;
        FeeData feeData = this.getFeeData(functionality, consensusTime, subType);
        return new FeeCalculatorImpl(txBody, payerKey, numVerifications, signatureMapSize, feeData, this.exchangeRateManager.activeRate(consensusTime), isInternalDispatch, this.congestionMultipliers, storeFactory, this.simpleFeesSchedule);
    }

    public long congestionMultiplierFor(@NonNull TransactionBody body, @NonNull HederaFunctionality functionality, @NonNull ReadableStoreFactory storeFactory) {
        return this.congestionMultipliers.maxCurrentMultiplier(body, functionality, storeFactory);
    }

    @NonNull
    public FeeCalculator createFeeCalculator(@NonNull HederaFunctionality functionality, @NonNull Instant consensusTime, @NonNull ReadableStoreFactory storeFactory) {
        FeeData feeData = this.getFeeData(functionality, consensusTime, SubType.DEFAULT);
        return new FeeCalculatorImpl(feeData, this.exchangeRateManager.activeRate(consensusTime), this.congestionMultipliers, storeFactory, functionality, this.simpleFeesSchedule);
    }

    @NonNull
    public FeeData getFeeData(@NonNull HederaFunctionality functionality, @NonNull Instant consensusTime, @NonNull SubType subType) {
        Map<Entry, FeeData> feeDataMap = consensusTime.getEpochSecond() > this.currentScheduleExpirationSeconds ? this.nextFeeDataMap : this.currentFeeDataMap;
        FeeData result = feeDataMap.get(new Entry(functionality, subType));
        if (result == null) {
            if (!INAPPLICABLE_OPERATIONS.contains(functionality)) {
                logger.warn("Using default usage prices to calculate fees for {}!", (Object)functionality);
            }
            return DEFAULT_FEE_DATA;
        }
        return result;
    }

    public long getGasPriceInTinyCents(@NonNull Instant consensusTime) {
        Objects.requireNonNull(consensusTime);
        return this.getFeeData(HederaFunctionality.CONTRACT_CALL, consensusTime, SubType.DEFAULT).servicedataOrThrow().gas() / 1000L;
    }

    @NonNull
    public ExchangeRateManager getExchangeRateManager() {
        return this.exchangeRateManager;
    }

    private void populateFeeDataMap(@NonNull Map<Entry, FeeData> feeDataMap, @NonNull List<TransactionFeeSchedule> feeSchedule) {
        feeSchedule.forEach(t -> {
            if (!t.fees().isEmpty()) {
                for (FeeData feeData : t.fees()) {
                    feeDataMap.put(new Entry(t.hederaFunctionality(), feeData.subType()), feeData);
                }
            } else if (t.hasFeeData()) {
                feeDataMap.put(new Entry(t.hederaFunctionality(), SubType.DEFAULT), t.feeDataOrThrow());
            } else {
                logger.warn("Neither `fees` nor `feeData` specified for transaction type {}, ignoring it.", (Object)t.hederaFunctionality());
            }
        });
    }

    @Nullable
    public SimpleFeeCalculator getSimpleFeeCalculator() {
        return this.simpleFeeCalculator;
    }

    private record Entry(HederaFunctionality function, SubType subType) {
    }
}

