/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state.recordcache;

import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.node.app.spi.records.RecordCache;
import com.hedera.node.app.spi.records.RecordSource;
import com.hedera.node.app.state.SingleTransactionRecord;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record LegacyListRecordSource(@NonNull List<SingleTransactionRecord> precomputedRecords, @NonNull List<RecordSource.IdentifiedReceipt> identifiedReceipts) implements RecordSource
{
    public void forEachTxnRecord(@NonNull Consumer<TransactionRecord> action) {
        Objects.requireNonNull(action);
        this.precomputedRecords.forEach(r -> action.accept(r.transactionRecord()));
    }

    public TransactionReceipt receiptOf(@NonNull TransactionID txnId) {
        Objects.requireNonNull(txnId);
        for (SingleTransactionRecord precomputed : this.precomputedRecords) {
            if (!txnId.equals((Object)precomputed.transactionRecord().transactionIDOrThrow())) continue;
            return precomputed.transactionRecord().receiptOrThrow();
        }
        throw new IllegalArgumentException();
    }

    public List<TransactionReceipt> childReceiptsOf(@NonNull TransactionID txnId) {
        Objects.requireNonNull(txnId);
        return this.precomputedRecords.stream().filter(r -> RecordCache.isChild((TransactionID)txnId, (TransactionID)r.transactionRecord().transactionIDOrThrow())).map(r -> r.transactionRecord().receiptOrThrow()).toList();
    }
}

