/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.validators;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.node.app.hapi.utils.contracts.HookUtils;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.HooksConfig;
import com.hedera.node.config.data.LedgerConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CryptoTransferValidator {
    private final EntityIdFactory entityIdFactory;

    @Inject
    public CryptoTransferValidator(EntityIdFactory entityIdFactory) {
        this.entityIdFactory = entityIdFactory;
    }

    public void pureChecks(@NonNull CryptoTransferTransactionBody op) throws PreCheckException {
        List acctAmounts = op.transfersOrElse(TransferList.DEFAULT).accountAmounts();
        PreCheckException.validateTruePreCheck((boolean)CryptoTransferValidator.isNetZeroAdjustment(acctAmounts), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_AMOUNTS);
        HashSet<AccountID> uniqueAcctIds = new HashSet<AccountID>();
        for (AccountAmount acctAmount : acctAmounts) {
            PreCheckException.validateTruePreCheck((boolean)acctAmount.hasAccountID(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
            AccountID acctId = Validations.validateAccountID((AccountID)acctAmount.accountIDOrThrow(), null);
            uniqueAcctIds.add(acctId);
            PreCheckException.validateFalsePreCheck((boolean)CryptoTransferValidator.hasApprovalAndHookExecution(acctAmount), (ResponseCodeEnum)ResponseCodeEnum.CANNOT_SET_HOOKS_AND_APPROVAL);
        }
        PreCheckException.validateFalsePreCheck((uniqueAcctIds.size() < acctAmounts.size() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_REPEATED_IN_ACCOUNT_AMOUNTS);
        CryptoTransferValidator.validateTokenTransfers(op.tokenTransfers(), AllowanceStrategy.ALLOWANCES_ALLOWED);
    }

    public void validateSemantics(@NonNull CryptoTransferTransactionBody op, @NonNull LedgerConfig ledgerConfig, @NonNull AccountsConfig accountsConfig, @NonNull HooksConfig hooksConfig, HandleContext.TransactionCategory category, @NonNull AccountID payer) {
        List hbarTransfers;
        TransferList transfers = op.transfersOrElse(TransferList.DEFAULT);
        if (HookUtils.hasHookExecutions((CryptoTransferTransactionBody)op)) {
            HandleException.validateTrue((boolean)hooksConfig.hooksEnabled(), (ResponseCodeEnum)ResponseCodeEnum.HOOKS_NOT_ENABLED);
            HandleException.validateTrue((boolean)category.equals((Object)HandleContext.TransactionCategory.USER), (ResponseCodeEnum)ResponseCodeEnum.HOOKS_EXECUTIONS_REQUIRE_TOP_LEVEL_CRYPTO_TRANSFER);
            this.validateHookGasLimitAndInvocations(op, hooksConfig);
        }
        if ((hbarTransfers = transfers.accountAmounts()).size() > ledgerConfig.transfersMaxLen()) {
            if (this.entityIdFactory.newAccountId(accountsConfig.systemAdmin()).equals((Object)payer)) {
                AccountID nodeRewardAccountId = this.entityIdFactory.newAccountId(accountsConfig.nodeRewardAccount());
                AccountID feeCollectionAccountId = this.entityIdFactory.newAccountId(accountsConfig.feeCollectionAccount());
                HandleException.validateTrue((boolean)hbarTransfers.stream().filter(aa -> aa.amount() < 0L).anyMatch(aa -> nodeRewardAccountId.equals((Object)aa.accountID()) || feeCollectionAccountId.equals((Object)aa.accountID())), (ResponseCodeEnum)ResponseCodeEnum.TRANSFER_LIST_SIZE_LIMIT_EXCEEDED);
            } else {
                throw new HandleException(ResponseCodeEnum.TRANSFER_LIST_SIZE_LIMIT_EXCEEDED);
            }
        }
        List tokenTransfers = op.tokenTransfers();
        int totalFungibleTransfers = 0;
        int totalNftTransfers = 0;
        for (TokenTransferList tokenTransfer : tokenTransfers) {
            List fungibleTransfers = tokenTransfer.transfers();
            List nftTransfers = tokenTransfer.nftTransfers();
            HandleException.validateTrue(((totalFungibleTransfers += fungibleTransfers.size()) <= ledgerConfig.tokenTransfersMaxLen() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_TRANSFER_LIST_SIZE_LIMIT_EXCEEDED);
            HandleException.validateTrue(((totalNftTransfers += nftTransfers.size()) <= ledgerConfig.nftTransfersMaxLen() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.BATCH_SIZE_LIMIT_EXCEEDED);
            AccountID feeCollectionAccount = this.entityIdFactory.newAccountId(accountsConfig.feeCollectionAccount());
            this.validateNoCreditsToFeeCollectionAccount(tokenTransfer, feeCollectionAccount);
        }
    }

    private void validateNoCreditsToFeeCollectionAccount(TokenTransferList transferList, AccountID feeCollectionAccount) {
        HandleException.validateTrue((boolean)transferList.transfers().stream().noneMatch(aa -> aa.amount() > 0L && aa.accountID().equals((Object)feeCollectionAccount)), (ResponseCodeEnum)ResponseCodeEnum.TRANSFER_TO_FEE_COLLECTION_ACCOUNT_NOT_ALLOWED);
        HandleException.validateTrue((boolean)transferList.nftTransfers().stream().noneMatch(nftTransfer -> nftTransfer.receiverAccountID().equals((Object)feeCollectionAccount)), (ResponseCodeEnum)ResponseCodeEnum.TRANSFER_TO_FEE_COLLECTION_ACCOUNT_NOT_ALLOWED);
    }

    private void validateHookGasLimitAndInvocations(CryptoTransferTransactionBody op, HooksConfig hooksConfig) {
        int gasLimit = hooksConfig.evmHookIntrinsicGasCost();
        int numHookInvocations = 0;
        for (AccountAmount aa : op.transfersOrElse(TransferList.DEFAULT).accountAmounts()) {
            numHookInvocations += CryptoTransferValidator.validateFungibleTransferHooks(aa, gasLimit);
        }
        for (TokenTransferList tokenTransfer : op.tokenTransfers()) {
            for (AccountAmount aa : tokenTransfer.transfers()) {
                numHookInvocations += CryptoTransferValidator.validateFungibleTransferHooks(aa, gasLimit);
            }
            for (NftTransfer nftTransfer : tokenTransfer.nftTransfers()) {
                numHookInvocations += this.validateNftTransferHooks(nftTransfer, gasLimit);
            }
        }
        HandleException.validateTrue((numHookInvocations <= hooksConfig.maxHookInvocationsPerTransaction() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOO_MANY_HOOK_INVOCATIONS);
    }

    private int validateNftTransferHooks(NftTransfer nftTransfer, int gasLimit) {
        int numInvocations = 0;
        if (nftTransfer.hasPreTxSenderAllowanceHook()) {
            ++numInvocations;
            HandleException.validateTrue((boolean)nftTransfer.preTxSenderAllowanceHookOrThrow().hasEvmHookCall(), (ResponseCodeEnum)ResponseCodeEnum.BAD_HOOK_REQUEST);
            HandleException.validateTrue((nftTransfer.preTxSenderAllowanceHookOrThrow().evmHookCallOrThrow().gasLimit() > (long)gasLimit ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_GAS);
        }
        if (nftTransfer.hasPrePostTxSenderAllowanceHook()) {
            numInvocations += 2;
            HandleException.validateTrue((boolean)nftTransfer.prePostTxSenderAllowanceHookOrThrow().hasEvmHookCall(), (ResponseCodeEnum)ResponseCodeEnum.BAD_HOOK_REQUEST);
            HandleException.validateTrue((nftTransfer.prePostTxSenderAllowanceHookOrThrow().evmHookCallOrThrow().gasLimit() > (long)gasLimit ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_GAS);
        }
        if (nftTransfer.hasPreTxReceiverAllowanceHook()) {
            ++numInvocations;
            HandleException.validateTrue((boolean)nftTransfer.preTxReceiverAllowanceHookOrThrow().hasEvmHookCall(), (ResponseCodeEnum)ResponseCodeEnum.BAD_HOOK_REQUEST);
            HandleException.validateTrue((nftTransfer.preTxReceiverAllowanceHookOrThrow().evmHookCallOrThrow().gasLimit() > (long)gasLimit ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_GAS);
        }
        if (nftTransfer.hasPrePostTxReceiverAllowanceHook()) {
            numInvocations += 2;
            HandleException.validateTrue((boolean)nftTransfer.prePostTxReceiverAllowanceHookOrThrow().hasEvmHookCall(), (ResponseCodeEnum)ResponseCodeEnum.BAD_HOOK_REQUEST);
            HandleException.validateTrue((nftTransfer.prePostTxReceiverAllowanceHookOrThrow().evmHookCallOrThrow().gasLimit() > (long)gasLimit ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_GAS);
        }
        return numInvocations;
    }

    private static int validateFungibleTransferHooks(AccountAmount aa, int gasLimit) {
        int numInvocations = 0;
        if (aa.hasPreTxAllowanceHook()) {
            ++numInvocations;
            HandleException.validateTrue((boolean)aa.preTxAllowanceHookOrThrow().hasEvmHookCall(), (ResponseCodeEnum)ResponseCodeEnum.BAD_HOOK_REQUEST);
            HandleException.validateTrue((aa.preTxAllowanceHookOrThrow().evmHookCallOrThrow().gasLimit() > (long)gasLimit ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_GAS);
        }
        if (aa.hasPrePostTxAllowanceHook()) {
            numInvocations += 2;
            HandleException.validateTrue((boolean)aa.prePostTxAllowanceHookOrThrow().hasEvmHookCall(), (ResponseCodeEnum)ResponseCodeEnum.BAD_HOOK_REQUEST);
            HandleException.validateTrue((aa.prePostTxAllowanceHookOrThrow().evmHookCallOrThrow().gasLimit() > (long)gasLimit ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_GAS);
        }
        return numInvocations;
    }

    public static void validateTokenTransfers(List<TokenTransferList> tokenTransfers, AllowanceStrategy allowanceStrategy) throws PreCheckException {
        HashSet<TokenID> tokenIds = new HashSet<TokenID>();
        for (TokenTransferList tokenTransfer : tokenTransfers) {
            TokenID tokenID = tokenTransfer.token();
            tokenIds.add(tokenID);
            PreCheckException.validateTruePreCheck((tokenID != null && !tokenID.equals((Object)TokenID.DEFAULT) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
            HashSet<AccountID> uniqueTokenAcctIds = new HashSet<AccountID>();
            CryptoTransferValidator.validateNonDuplicateFungibleTransfers(tokenTransfer.transfers(), uniqueTokenAcctIds, allowanceStrategy);
            HashSet<Long> nftIds = new HashSet<Long>();
            CryptoTransferValidator.validateNftTransfers(tokenTransfer.nftTransfers(), nftIds, allowanceStrategy);
            PreCheckException.validateFalsePreCheck((uniqueTokenAcctIds.isEmpty() && nftIds.isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.EMPTY_TOKEN_TRANSFER_ACCOUNT_AMOUNTS);
        }
        PreCheckException.validateFalsePreCheck((tokenIds.size() < tokenTransfers.size() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_ID_REPEATED_IN_TOKEN_LIST);
    }

    public static void validateNonDuplicateFungibleTransfers(List<AccountAmount> fungibleTransfers, Set<AccountID> uniqueTokenAcctIds, AllowanceStrategy allowanceStrategy) throws PreCheckException {
        PreCheckException.validateTruePreCheck((boolean)CryptoTransferValidator.isNetZeroAdjustment(fungibleTransfers), (ResponseCodeEnum)ResponseCodeEnum.TRANSFERS_NOT_ZERO_SUM_FOR_TOKEN);
        boolean nonZeroFungibleValueFound = false;
        for (AccountAmount acctAmount : fungibleTransfers) {
            if (allowanceStrategy.equals((Object)AllowanceStrategy.ALLOWANCES_REJECTED)) {
                PreCheckException.validateFalsePreCheck((boolean)acctAmount.isApproval(), (ResponseCodeEnum)ResponseCodeEnum.NOT_SUPPORTED);
            }
            PreCheckException.validateTruePreCheck((boolean)acctAmount.hasAccountID(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSFER_ACCOUNT_ID);
            uniqueTokenAcctIds.add(acctAmount.accountIDOrThrow());
            if (!nonZeroFungibleValueFound && acctAmount.amount() != 0L) {
                nonZeroFungibleValueFound = true;
            }
            PreCheckException.validateFalsePreCheck((boolean)CryptoTransferValidator.hasApprovalAndHookExecution(acctAmount), (ResponseCodeEnum)ResponseCodeEnum.CANNOT_SET_HOOKS_AND_APPROVAL);
        }
        PreCheckException.validateFalsePreCheck((uniqueTokenAcctIds.size() < fungibleTransfers.size() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_REPEATED_IN_ACCOUNT_AMOUNTS);
    }

    private static boolean hasApprovalAndHookExecution(AccountAmount acctAmount) {
        return acctAmount.isApproval() && (acctAmount.hasPreTxAllowanceHook() || acctAmount.hasPrePostTxAllowanceHook());
    }

    private static boolean hasApprovalAndHookExecution(NftTransfer nftTransfer) {
        return nftTransfer.isApproval() && (nftTransfer.hasPreTxSenderAllowanceHook() || nftTransfer.hasPrePostTxSenderAllowanceHook());
    }

    public static void validateNftTransfers(List<NftTransfer> nftTransfers, Set<Long> nftIds, AllowanceStrategy allowanceStrategy) throws PreCheckException {
        for (NftTransfer nftTransfer : nftTransfers) {
            if (allowanceStrategy.equals((Object)AllowanceStrategy.ALLOWANCES_REJECTED)) {
                PreCheckException.validateFalsePreCheck((boolean)nftTransfer.isApproval(), (ResponseCodeEnum)ResponseCodeEnum.NOT_SUPPORTED);
            }
            PreCheckException.validateTruePreCheck((nftTransfer.serialNumber() > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER);
            PreCheckException.validateTruePreCheck((boolean)nftTransfer.hasSenderAccountID(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSFER_ACCOUNT_ID);
            PreCheckException.validateTruePreCheck((boolean)nftTransfer.hasReceiverAccountID(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSFER_ACCOUNT_ID);
            PreCheckException.validateFalsePreCheck((!nftIds.isEmpty() && nftIds.contains(nftTransfer.serialNumber()) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_AMOUNTS);
            PreCheckException.validateFalsePreCheck((boolean)nftTransfer.senderAccountIDOrThrow().equals((Object)nftTransfer.receiverAccountID()), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_REPEATED_IN_ACCOUNT_AMOUNTS);
            PreCheckException.validateFalsePreCheck((boolean)CryptoTransferValidator.hasApprovalAndHookExecution(nftTransfer), (ResponseCodeEnum)ResponseCodeEnum.CANNOT_SET_HOOKS_AND_APPROVAL);
            nftIds.add(nftTransfer.serialNumber());
        }
    }

    private static boolean isNetZeroAdjustment(@NonNull List<AccountAmount> adjusts) {
        BigInteger net = BigInteger.ZERO;
        for (AccountAmount adjust : adjusts) {
            net = net.add(BigInteger.valueOf(adjust.amount()));
        }
        return net.equals(BigInteger.ZERO);
    }

    public static enum AllowanceStrategy {
        ALLOWANCES_ALLOWED,
        ALLOWANCES_REJECTED;

    }
}

