/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.hapi.node.transaction.TransactionResponse;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.GrpcCall;
import com.hedera.pbj.runtime.grpc.GrpcClient;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.Pipelines;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;

public interface SmartContractServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "SmartContractService";
    public static final String FULL_NAME = "proto.SmartContractService";

    @NonNull
    public TransactionResponse createContract(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse updateContract(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse contractCallMethod(@NonNull Transaction var1);

    @NonNull
    public Response contractCallLocalMethod(@NonNull Query var1);

    @NonNull
    public Response getContractInfo(@NonNull Query var1);

    @NonNull
    public Response ContractGetBytecode(@NonNull Query var1);

    @NonNull
    public Response getBySolidityID(@NonNull Query var1);

    @NonNull
    public Response getTxRecordByContractID(@NonNull Query var1);

    @NonNull
    public TransactionResponse deleteContract(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse systemDelete(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse systemUndelete(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse callEthereum(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse hookStore(@NonNull Transaction var1);

    @NonNull
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @NonNull
    default public String fullName() {
        return FULL_NAME;
    }

    @NonNull
    default public List<ServiceInterface.Method> methods() {
        return Arrays.asList(SmartContractServiceMethod.values());
    }

    @NonNull
    default public Pipeline<? super Bytes> open(@NonNull ServiceInterface.Method method, @NonNull ServiceInterface.RequestOptions options, @NonNull Pipeline<? super Bytes> replies) {
        SmartContractServiceMethod m = (SmartContractServiceMethod)method;
        try {
            return switch (m.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Pipelines.unary().mapRequest(bytes -> SmartContractServiceInterface.parseTransaction(bytes, options)).method(this::createContract).mapResponse(reply -> SmartContractServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 1 -> Pipelines.unary().mapRequest(bytes -> SmartContractServiceInterface.parseTransaction(bytes, options)).method(this::updateContract).mapResponse(reply -> SmartContractServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 2 -> Pipelines.unary().mapRequest(bytes -> SmartContractServiceInterface.parseTransaction(bytes, options)).method(this::contractCallMethod).mapResponse(reply -> SmartContractServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 3 -> Pipelines.unary().mapRequest(bytes -> SmartContractServiceInterface.parseQuery(bytes, options)).method(this::contractCallLocalMethod).mapResponse(reply -> SmartContractServiceInterface.serializeResponse(reply, options)).respondTo(replies).build();
                case 4 -> Pipelines.unary().mapRequest(bytes -> SmartContractServiceInterface.parseQuery(bytes, options)).method(this::getContractInfo).mapResponse(reply -> SmartContractServiceInterface.serializeResponse(reply, options)).respondTo(replies).build();
                case 5 -> Pipelines.unary().mapRequest(bytes -> SmartContractServiceInterface.parseQuery(bytes, options)).method(this::ContractGetBytecode).mapResponse(reply -> SmartContractServiceInterface.serializeResponse(reply, options)).respondTo(replies).build();
                case 6 -> Pipelines.unary().mapRequest(bytes -> SmartContractServiceInterface.parseQuery(bytes, options)).method(this::getBySolidityID).mapResponse(reply -> SmartContractServiceInterface.serializeResponse(reply, options)).respondTo(replies).build();
                case 7 -> Pipelines.unary().mapRequest(bytes -> SmartContractServiceInterface.parseQuery(bytes, options)).method(this::getTxRecordByContractID).mapResponse(reply -> SmartContractServiceInterface.serializeResponse(reply, options)).respondTo(replies).build();
                case 8 -> Pipelines.unary().mapRequest(bytes -> SmartContractServiceInterface.parseTransaction(bytes, options)).method(this::deleteContract).mapResponse(reply -> SmartContractServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 9 -> Pipelines.unary().mapRequest(bytes -> SmartContractServiceInterface.parseTransaction(bytes, options)).method(this::systemDelete).mapResponse(reply -> SmartContractServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 10 -> Pipelines.unary().mapRequest(bytes -> SmartContractServiceInterface.parseTransaction(bytes, options)).method(this::systemUndelete).mapResponse(reply -> SmartContractServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 11 -> Pipelines.unary().mapRequest(bytes -> SmartContractServiceInterface.parseTransaction(bytes, options)).method(this::callEthereum).mapResponse(reply -> SmartContractServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 12 -> Pipelines.unary().mapRequest(bytes -> SmartContractServiceInterface.parseTransaction(bytes, options)).method(this::hookStore).mapResponse(reply -> SmartContractServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
            };
        }
        catch (Exception e) {
            replies.onError((Throwable)e);
            return Pipelines.noop();
        }
    }

    @NonNull
    private static Codec<Transaction> getTransactionCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Transaction.JSON;
        }
        return Transaction.PROTOBUF;
    }

    @NonNull
    private static Codec<TransactionResponse> getTransactionResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return TransactionResponse.JSON;
        }
        return TransactionResponse.PROTOBUF;
    }

    @NonNull
    private static Codec<Query> getQueryCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Query.JSON;
        }
        return Query.PROTOBUF;
    }

    @NonNull
    private static Codec<Response> getResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Response.JSON;
        }
        return Response.PROTOBUF;
    }

    @NonNull
    private static Transaction parseTransaction(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (Transaction)SmartContractServiceInterface.getTransactionCodec(options).parse(message.toReadableSequentialData(), false, false, 16, options.maxMessageSizeBytes());
    }

    @NonNull
    private static Query parseQuery(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (Query)SmartContractServiceInterface.getQueryCodec(options).parse(message.toReadableSequentialData(), false, false, 16, options.maxMessageSizeBytes());
    }

    @NonNull
    private static Bytes serializeTransactionResponse(@NonNull TransactionResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return SmartContractServiceInterface.getTransactionResponseCodec(options).toBytes((Object)reply);
    }

    @NonNull
    private static Bytes serializeResponse(@NonNull Response reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return SmartContractServiceInterface.getResponseCodec(options).toBytes((Object)reply);
    }

    public static enum SmartContractServiceMethod implements ServiceInterface.Method
    {
        createContract,
        updateContract,
        contractCallMethod,
        contractCallLocalMethod,
        getContractInfo,
        ContractGetBytecode,
        getBySolidityID,
        getTxRecordByContractID,
        deleteContract,
        systemDelete,
        systemUndelete,
        callEthereum,
        hookStore;

    }

    public static class SmartContractServiceClient
    implements SmartContractServiceInterface {
        private final GrpcClient grpcClient;
        private final ServiceInterface.RequestOptions requestOptions;

        public SmartContractServiceClient(@NonNull GrpcClient grpcClient, @NonNull ServiceInterface.RequestOptions requestOptions) {
            this.grpcClient = Objects.requireNonNull(grpcClient);
            this.requestOptions = Objects.requireNonNull(requestOptions);
        }

        public void close() {
            this.grpcClient.close();
        }

        @Override
        @NonNull
        public TransactionResponse createContract(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("createContract is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.SmartContractService/createContract", SmartContractServiceInterface.getTransactionCodec(this.requestOptions), SmartContractServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to createContract completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse updateContract(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("updateContract is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.SmartContractService/updateContract", SmartContractServiceInterface.getTransactionCodec(this.requestOptions), SmartContractServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to updateContract completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse contractCallMethod(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("contractCallMethod is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.SmartContractService/contractCallMethod", SmartContractServiceInterface.getTransactionCodec(this.requestOptions), SmartContractServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to contractCallMethod completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public Response contractCallLocalMethod(@NonNull Query request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<Response> pipeline = new Pipeline<Response>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(Response reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("contractCallLocalMethod is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.SmartContractService/contractCallLocalMethod", SmartContractServiceInterface.getQueryCodec(this.requestOptions), SmartContractServiceInterface.getResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (Response)replyRef.get();
            }
            throw new RuntimeException("Call to contractCallLocalMethod completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public Response getContractInfo(@NonNull Query request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<Response> pipeline = new Pipeline<Response>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(Response reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("getContractInfo is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.SmartContractService/getContractInfo", SmartContractServiceInterface.getQueryCodec(this.requestOptions), SmartContractServiceInterface.getResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (Response)replyRef.get();
            }
            throw new RuntimeException("Call to getContractInfo completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public Response ContractGetBytecode(@NonNull Query request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<Response> pipeline = new Pipeline<Response>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(Response reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("ContractGetBytecode is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.SmartContractService/ContractGetBytecode", SmartContractServiceInterface.getQueryCodec(this.requestOptions), SmartContractServiceInterface.getResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (Response)replyRef.get();
            }
            throw new RuntimeException("Call to ContractGetBytecode completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public Response getBySolidityID(@NonNull Query request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<Response> pipeline = new Pipeline<Response>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(Response reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("getBySolidityID is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.SmartContractService/getBySolidityID", SmartContractServiceInterface.getQueryCodec(this.requestOptions), SmartContractServiceInterface.getResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (Response)replyRef.get();
            }
            throw new RuntimeException("Call to getBySolidityID completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public Response getTxRecordByContractID(@NonNull Query request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<Response> pipeline = new Pipeline<Response>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(Response reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("getTxRecordByContractID is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.SmartContractService/getTxRecordByContractID", SmartContractServiceInterface.getQueryCodec(this.requestOptions), SmartContractServiceInterface.getResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (Response)replyRef.get();
            }
            throw new RuntimeException("Call to getTxRecordByContractID completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse deleteContract(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("deleteContract is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.SmartContractService/deleteContract", SmartContractServiceInterface.getTransactionCodec(this.requestOptions), SmartContractServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to deleteContract completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse systemDelete(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("systemDelete is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.SmartContractService/systemDelete", SmartContractServiceInterface.getTransactionCodec(this.requestOptions), SmartContractServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to systemDelete completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse systemUndelete(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("systemUndelete is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.SmartContractService/systemUndelete", SmartContractServiceInterface.getTransactionCodec(this.requestOptions), SmartContractServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to systemUndelete completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse callEthereum(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("callEthereum is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.SmartContractService/callEthereum", SmartContractServiceInterface.getTransactionCodec(this.requestOptions), SmartContractServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to callEthereum completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse hookStore(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("hookStore is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.SmartContractService/hookStore", SmartContractServiceInterface.getTransactionCodec(this.requestOptions), SmartContractServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to hookStore completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }
    }
}

