/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.schedule;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.state.schedule.codec.ScheduleJsonCodec;
import com.hedera.hapi.node.state.schedule.codec.ScheduleProtoCodec;
import com.hedera.hapi.node.state.schedule.schema.ScheduleSchema;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class Schedule {
    public static final Codec<Schedule> PROTOBUF = new ScheduleProtoCodec();
    public static final JsonCodec<Schedule> JSON = new ScheduleJsonCodec();
    public static final Schedule DEFAULT = Schedule.newBuilder().build();
    @Nullable
    private final ScheduleID scheduleId;
    private final boolean deleted;
    private final boolean executed;
    private final boolean waitForExpiry;
    @NonNull
    private final String memo;
    @Nullable
    private final AccountID schedulerAccountId;
    @Nullable
    private final AccountID payerAccountId;
    @Nullable
    private final Key adminKey;
    @Nullable
    private final Timestamp scheduleValidStart;
    private final long providedExpirationSecond;
    private final long calculatedExpirationSecond;
    @Nullable
    private final Timestamp resolutionTime;
    @Nullable
    private final SchedulableTransactionBody scheduledTransaction;
    @Nullable
    private final TransactionBody originalCreateTransaction;
    @NonNull
    private final List<Key> signatories;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public Schedule(ScheduleID scheduleId, boolean deleted, boolean executed, boolean waitForExpiry, String memo, AccountID schedulerAccountId, AccountID payerAccountId, Key adminKey, Timestamp scheduleValidStart, long providedExpirationSecond, long calculatedExpirationSecond, Timestamp resolutionTime, SchedulableTransactionBody scheduledTransaction, TransactionBody originalCreateTransaction, List<Key> signatories) {
        this.$unknownFields = null;
        this.scheduleId = scheduleId;
        this.deleted = deleted;
        this.executed = executed;
        this.waitForExpiry = waitForExpiry;
        this.memo = memo != null ? memo : "";
        this.schedulerAccountId = schedulerAccountId;
        this.payerAccountId = payerAccountId;
        this.adminKey = adminKey;
        this.scheduleValidStart = scheduleValidStart;
        this.providedExpirationSecond = providedExpirationSecond;
        this.calculatedExpirationSecond = calculatedExpirationSecond;
        this.resolutionTime = resolutionTime;
        this.scheduledTransaction = scheduledTransaction;
        this.originalCreateTransaction = originalCreateTransaction;
        this.signatories = signatories == null ? Collections.emptyList() : signatories;
    }

    public Schedule(ScheduleID scheduleId, boolean deleted, boolean executed, boolean waitForExpiry, String memo, AccountID schedulerAccountId, AccountID payerAccountId, Key adminKey, Timestamp scheduleValidStart, long providedExpirationSecond, long calculatedExpirationSecond, Timestamp resolutionTime, SchedulableTransactionBody scheduledTransaction, TransactionBody originalCreateTransaction, List<Key> signatories, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.scheduleId = scheduleId;
        this.deleted = deleted;
        this.executed = executed;
        this.waitForExpiry = waitForExpiry;
        this.memo = memo != null ? memo : "";
        this.schedulerAccountId = schedulerAccountId;
        this.payerAccountId = payerAccountId;
        this.adminKey = adminKey;
        this.scheduleValidStart = scheduleValidStart;
        this.providedExpirationSecond = providedExpirationSecond;
        this.calculatedExpirationSecond = calculatedExpirationSecond;
        this.resolutionTime = resolutionTime;
        this.scheduledTransaction = scheduledTransaction;
        this.originalCreateTransaction = originalCreateTransaction;
        this.signatories = signatories == null ? Collections.emptyList() : signatories;
    }

    public ScheduleID scheduleId() {
        return this.scheduleId;
    }

    public boolean deleted() {
        return this.deleted;
    }

    public boolean executed() {
        return this.executed;
    }

    public boolean waitForExpiry() {
        return this.waitForExpiry;
    }

    public String memo() {
        return this.memo;
    }

    public AccountID schedulerAccountId() {
        return this.schedulerAccountId;
    }

    public AccountID payerAccountId() {
        return this.payerAccountId;
    }

    public Key adminKey() {
        return this.adminKey;
    }

    public Timestamp scheduleValidStart() {
        return this.scheduleValidStart;
    }

    public long providedExpirationSecond() {
        return this.providedExpirationSecond;
    }

    public long calculatedExpirationSecond() {
        return this.calculatedExpirationSecond;
    }

    public Timestamp resolutionTime() {
        return this.resolutionTime;
    }

    public SchedulableTransactionBody scheduledTransaction() {
        return this.scheduledTransaction;
    }

    public TransactionBody originalCreateTransaction() {
        return this.originalCreateTransaction;
    }

    public List<Key> signatories() {
        return this.signatories;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleSchema.SCHEDULE_ID, (Object)this.scheduleId, ScheduleID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)ScheduleSchema.DELETED, (boolean)this.deleted, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)ScheduleSchema.EXECUTED, (boolean)this.executed, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)ScheduleSchema.WAIT_FOR_EXPIRY, (boolean)this.waitForExpiry, (boolean)true);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)ScheduleSchema.MEMO, (String)this.memo, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleSchema.SCHEDULER_ACCOUNT_ID, (Object)this.schedulerAccountId, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleSchema.PAYER_ACCOUNT_ID, (Object)this.payerAccountId, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleSchema.ADMIN_KEY, (Object)this.adminKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleSchema.SCHEDULE_VALID_START, (Object)this.scheduleValidStart, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)ScheduleSchema.PROVIDED_EXPIRATION_SECOND, (long)this.providedExpirationSecond, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)ScheduleSchema.CALCULATED_EXPIRATION_SECOND, (long)this.calculatedExpirationSecond, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleSchema.RESOLUTION_TIME, (Object)this.resolutionTime, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleSchema.SCHEDULED_TRANSACTION, (Object)this.scheduledTransaction, SchedulableTransactionBody.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleSchema.ORIGINAL_CREATE_TRANSACTION, (Object)this.originalCreateTransaction, TransactionBody.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)ScheduleSchema.SIGNATORIES, this.signatories, Key.PROTOBUF);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            List<Key> list$signatories;
            int result = 1;
            if (this.scheduleId != null && !this.scheduleId.equals(Schedule.DEFAULT.scheduleId)) {
                result = 31 * result + this.scheduleId.hashCode();
            }
            if (this.deleted != Schedule.DEFAULT.deleted) {
                result = 31 * result + Boolean.hashCode(this.deleted);
            }
            if (this.executed != Schedule.DEFAULT.executed) {
                result = 31 * result + Boolean.hashCode(this.executed);
            }
            if (this.waitForExpiry != Schedule.DEFAULT.waitForExpiry) {
                result = 31 * result + Boolean.hashCode(this.waitForExpiry);
            }
            if (this.memo != null && !this.memo.equals(Schedule.DEFAULT.memo)) {
                result = 31 * result + this.memo.hashCode();
            }
            if (this.schedulerAccountId != null && !this.schedulerAccountId.equals(Schedule.DEFAULT.schedulerAccountId)) {
                result = 31 * result + this.schedulerAccountId.hashCode();
            }
            if (this.payerAccountId != null && !this.payerAccountId.equals(Schedule.DEFAULT.payerAccountId)) {
                result = 31 * result + this.payerAccountId.hashCode();
            }
            if (this.adminKey != null && !this.adminKey.equals(Schedule.DEFAULT.adminKey)) {
                result = 31 * result + this.adminKey.hashCode();
            }
            if (this.scheduleValidStart != null && !this.scheduleValidStart.equals(Schedule.DEFAULT.scheduleValidStart)) {
                result = 31 * result + this.scheduleValidStart.hashCode();
            }
            if (this.providedExpirationSecond != Schedule.DEFAULT.providedExpirationSecond) {
                result = 31 * result + Long.hashCode(this.providedExpirationSecond);
            }
            if (this.calculatedExpirationSecond != Schedule.DEFAULT.calculatedExpirationSecond) {
                result = 31 * result + Long.hashCode(this.calculatedExpirationSecond);
            }
            if (this.resolutionTime != null && !this.resolutionTime.equals(Schedule.DEFAULT.resolutionTime)) {
                result = 31 * result + this.resolutionTime.hashCode();
            }
            if (this.scheduledTransaction != null && !this.scheduledTransaction.equals(Schedule.DEFAULT.scheduledTransaction)) {
                result = 31 * result + this.scheduledTransaction.hashCode();
            }
            if (this.originalCreateTransaction != null && !this.originalCreateTransaction.equals(Schedule.DEFAULT.originalCreateTransaction)) {
                result = 31 * result + this.originalCreateTransaction.hashCode();
            }
            if ((list$signatories = this.signatories) != null) {
                for (Key o : list$signatories) {
                    if (o != null) {
                        result = 31 * result + ((Object)o).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Schedule thatObj = (Schedule)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.scheduleId == null && thatObj.scheduleId != null) {
            return false;
        }
        if (this.scheduleId != null && !this.scheduleId.equals(thatObj.scheduleId)) {
            return false;
        }
        if (this.deleted != thatObj.deleted) {
            return false;
        }
        if (this.executed != thatObj.executed) {
            return false;
        }
        if (this.waitForExpiry != thatObj.waitForExpiry) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.schedulerAccountId == null && thatObj.schedulerAccountId != null) {
            return false;
        }
        if (this.schedulerAccountId != null && !this.schedulerAccountId.equals(thatObj.schedulerAccountId)) {
            return false;
        }
        if (this.payerAccountId == null && thatObj.payerAccountId != null) {
            return false;
        }
        if (this.payerAccountId != null && !this.payerAccountId.equals(thatObj.payerAccountId)) {
            return false;
        }
        if (this.adminKey == null && thatObj.adminKey != null) {
            return false;
        }
        if (this.adminKey != null && !this.adminKey.equals(thatObj.adminKey)) {
            return false;
        }
        if (this.scheduleValidStart == null && thatObj.scheduleValidStart != null) {
            return false;
        }
        if (this.scheduleValidStart != null && !this.scheduleValidStart.equals(thatObj.scheduleValidStart)) {
            return false;
        }
        if (this.providedExpirationSecond != thatObj.providedExpirationSecond) {
            return false;
        }
        if (this.calculatedExpirationSecond != thatObj.calculatedExpirationSecond) {
            return false;
        }
        if (this.resolutionTime == null && thatObj.resolutionTime != null) {
            return false;
        }
        if (this.resolutionTime != null && !this.resolutionTime.equals(thatObj.resolutionTime)) {
            return false;
        }
        if (this.scheduledTransaction == null && thatObj.scheduledTransaction != null) {
            return false;
        }
        if (this.scheduledTransaction != null && !this.scheduledTransaction.equals(thatObj.scheduledTransaction)) {
            return false;
        }
        if (this.originalCreateTransaction == null && thatObj.originalCreateTransaction != null) {
            return false;
        }
        if (this.originalCreateTransaction != null && !this.originalCreateTransaction.equals(thatObj.originalCreateTransaction)) {
            return false;
        }
        if (this.signatories == null && thatObj.signatories != null) {
            return false;
        }
        if (this.signatories != null && !this.signatories.equals(thatObj.signatories)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "Schedule[scheduleId=" + String.valueOf(this.scheduleId) + ", deleted=" + this.deleted + ", executed=" + this.executed + ", waitForExpiry=" + this.waitForExpiry + ", memo=" + this.memo + ", schedulerAccountId=" + String.valueOf(this.schedulerAccountId) + ", payerAccountId=" + String.valueOf(this.payerAccountId) + ", adminKey=" + String.valueOf(this.adminKey) + ", scheduleValidStart=" + String.valueOf(this.scheduleValidStart) + ", providedExpirationSecond=" + this.providedExpirationSecond + ", calculatedExpirationSecond=" + this.calculatedExpirationSecond + ", resolutionTime=" + String.valueOf(this.resolutionTime) + ", scheduledTransaction=" + String.valueOf(this.scheduledTransaction) + ", originalCreateTransaction=" + String.valueOf(this.originalCreateTransaction) + ", signatories=" + String.valueOf(this.signatories) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasScheduleId() {
        return this.scheduleId != null;
    }

    public ScheduleID scheduleIdOrElse(@NonNull ScheduleID defaultValue) {
        return this.hasScheduleId() ? this.scheduleId : defaultValue;
    }

    @NonNull
    public ScheduleID scheduleIdOrThrow() {
        return Objects.requireNonNull(this.scheduleId, "Field scheduleId is null");
    }

    public void ifScheduleId(@NonNull Consumer<ScheduleID> ifPresent) {
        if (this.hasScheduleId()) {
            ifPresent.accept(this.scheduleId);
        }
    }

    public boolean hasSchedulerAccountId() {
        return this.schedulerAccountId != null;
    }

    public AccountID schedulerAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasSchedulerAccountId() ? this.schedulerAccountId : defaultValue;
    }

    @NonNull
    public AccountID schedulerAccountIdOrThrow() {
        return Objects.requireNonNull(this.schedulerAccountId, "Field schedulerAccountId is null");
    }

    public void ifSchedulerAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSchedulerAccountId()) {
            ifPresent.accept(this.schedulerAccountId);
        }
    }

    public boolean hasPayerAccountId() {
        return this.payerAccountId != null;
    }

    public AccountID payerAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasPayerAccountId() ? this.payerAccountId : defaultValue;
    }

    @NonNull
    public AccountID payerAccountIdOrThrow() {
        return Objects.requireNonNull(this.payerAccountId, "Field payerAccountId is null");
    }

    public void ifPayerAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasPayerAccountId()) {
            ifPresent.accept(this.payerAccountId);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasScheduleValidStart() {
        return this.scheduleValidStart != null;
    }

    public Timestamp scheduleValidStartOrElse(@NonNull Timestamp defaultValue) {
        return this.hasScheduleValidStart() ? this.scheduleValidStart : defaultValue;
    }

    @NonNull
    public Timestamp scheduleValidStartOrThrow() {
        return Objects.requireNonNull(this.scheduleValidStart, "Field scheduleValidStart is null");
    }

    public void ifScheduleValidStart(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasScheduleValidStart()) {
            ifPresent.accept(this.scheduleValidStart);
        }
    }

    public boolean hasResolutionTime() {
        return this.resolutionTime != null;
    }

    public Timestamp resolutionTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasResolutionTime() ? this.resolutionTime : defaultValue;
    }

    @NonNull
    public Timestamp resolutionTimeOrThrow() {
        return Objects.requireNonNull(this.resolutionTime, "Field resolutionTime is null");
    }

    public void ifResolutionTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasResolutionTime()) {
            ifPresent.accept(this.resolutionTime);
        }
    }

    public boolean hasScheduledTransaction() {
        return this.scheduledTransaction != null;
    }

    public SchedulableTransactionBody scheduledTransactionOrElse(@NonNull SchedulableTransactionBody defaultValue) {
        return this.hasScheduledTransaction() ? this.scheduledTransaction : defaultValue;
    }

    @NonNull
    public SchedulableTransactionBody scheduledTransactionOrThrow() {
        return Objects.requireNonNull(this.scheduledTransaction, "Field scheduledTransaction is null");
    }

    public void ifScheduledTransaction(@NonNull Consumer<SchedulableTransactionBody> ifPresent) {
        if (this.hasScheduledTransaction()) {
            ifPresent.accept(this.scheduledTransaction);
        }
    }

    public boolean hasOriginalCreateTransaction() {
        return this.originalCreateTransaction != null;
    }

    public TransactionBody originalCreateTransactionOrElse(@NonNull TransactionBody defaultValue) {
        return this.hasOriginalCreateTransaction() ? this.originalCreateTransaction : defaultValue;
    }

    @NonNull
    public TransactionBody originalCreateTransactionOrThrow() {
        return Objects.requireNonNull(this.originalCreateTransaction, "Field originalCreateTransaction is null");
    }

    public void ifOriginalCreateTransaction(@NonNull Consumer<TransactionBody> ifPresent) {
        if (this.hasOriginalCreateTransaction()) {
            ifPresent.accept(this.originalCreateTransaction);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.scheduleId, this.deleted, this.executed, this.waitForExpiry, this.memo, this.schedulerAccountId, this.payerAccountId, this.adminKey, this.scheduleValidStart, this.providedExpirationSecond, this.calculatedExpirationSecond, this.resolutionTime, this.scheduledTransaction, this.originalCreateTransaction, this.signatories, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private ScheduleID scheduleId = null;
        private boolean deleted = false;
        private boolean executed = false;
        private boolean waitForExpiry = false;
        @NonNull
        private String memo = "";
        @Nullable
        private AccountID schedulerAccountId = null;
        @Nullable
        private AccountID payerAccountId = null;
        @Nullable
        private Key adminKey = null;
        @Nullable
        private Timestamp scheduleValidStart = null;
        private long providedExpirationSecond = 0L;
        private long calculatedExpirationSecond = 0L;
        @Nullable
        private Timestamp resolutionTime = null;
        @Nullable
        private SchedulableTransactionBody scheduledTransaction = null;
        @Nullable
        private TransactionBody originalCreateTransaction = null;
        @NonNull
        private List<Key> signatories = Collections.emptyList();
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(ScheduleID scheduleId, boolean deleted, boolean executed, boolean waitForExpiry, String memo, AccountID schedulerAccountId, AccountID payerAccountId, Key adminKey, Timestamp scheduleValidStart, long providedExpirationSecond, long calculatedExpirationSecond, Timestamp resolutionTime, SchedulableTransactionBody scheduledTransaction, TransactionBody originalCreateTransaction, List<Key> signatories) {
            this.$unknownFields = null;
            this.scheduleId = scheduleId;
            this.deleted = deleted;
            this.executed = executed;
            this.waitForExpiry = waitForExpiry;
            this.memo = memo != null ? memo : "";
            this.schedulerAccountId = schedulerAccountId;
            this.payerAccountId = payerAccountId;
            this.adminKey = adminKey;
            this.scheduleValidStart = scheduleValidStart;
            this.providedExpirationSecond = providedExpirationSecond;
            this.calculatedExpirationSecond = calculatedExpirationSecond;
            this.resolutionTime = resolutionTime;
            this.scheduledTransaction = scheduledTransaction;
            this.originalCreateTransaction = originalCreateTransaction;
            this.signatories = signatories == null ? Collections.emptyList() : signatories;
        }

        public Builder(ScheduleID scheduleId, boolean deleted, boolean executed, boolean waitForExpiry, String memo, AccountID schedulerAccountId, AccountID payerAccountId, Key adminKey, Timestamp scheduleValidStart, long providedExpirationSecond, long calculatedExpirationSecond, Timestamp resolutionTime, SchedulableTransactionBody scheduledTransaction, TransactionBody originalCreateTransaction, List<Key> signatories, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.scheduleId = scheduleId;
            this.deleted = deleted;
            this.executed = executed;
            this.waitForExpiry = waitForExpiry;
            this.memo = memo != null ? memo : "";
            this.schedulerAccountId = schedulerAccountId;
            this.payerAccountId = payerAccountId;
            this.adminKey = adminKey;
            this.scheduleValidStart = scheduleValidStart;
            this.providedExpirationSecond = providedExpirationSecond;
            this.calculatedExpirationSecond = calculatedExpirationSecond;
            this.resolutionTime = resolutionTime;
            this.scheduledTransaction = scheduledTransaction;
            this.originalCreateTransaction = originalCreateTransaction;
            this.signatories = signatories == null ? Collections.emptyList() : signatories;
        }

        public Schedule build() {
            return new Schedule(this.scheduleId, this.deleted, this.executed, this.waitForExpiry, this.memo, this.schedulerAccountId, this.payerAccountId, this.adminKey, this.scheduleValidStart, this.providedExpirationSecond, this.calculatedExpirationSecond, this.resolutionTime, this.scheduledTransaction, this.originalCreateTransaction, this.signatories);
        }

        public Builder scheduleId(@Nullable ScheduleID scheduleId) {
            this.scheduleId = scheduleId;
            return this;
        }

        public Builder scheduleId(ScheduleID.Builder builder) {
            this.scheduleId = builder.build();
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder executed(boolean executed) {
            this.executed = executed;
            return this;
        }

        public Builder waitForExpiry(boolean waitForExpiry) {
            this.waitForExpiry = waitForExpiry;
            return this;
        }

        public Builder memo(@NonNull String memo) {
            this.memo = memo != null ? memo : "";
            return this;
        }

        public Builder schedulerAccountId(@Nullable AccountID schedulerAccountId) {
            this.schedulerAccountId = schedulerAccountId;
            return this;
        }

        public Builder schedulerAccountId(AccountID.Builder builder) {
            this.schedulerAccountId = builder.build();
            return this;
        }

        public Builder payerAccountId(@Nullable AccountID payerAccountId) {
            this.payerAccountId = payerAccountId;
            return this;
        }

        public Builder payerAccountId(AccountID.Builder builder) {
            this.payerAccountId = builder.build();
            return this;
        }

        public Builder adminKey(@Nullable Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder scheduleValidStart(@Nullable Timestamp scheduleValidStart) {
            this.scheduleValidStart = scheduleValidStart;
            return this;
        }

        public Builder scheduleValidStart(Timestamp.Builder builder) {
            this.scheduleValidStart = builder.build();
            return this;
        }

        public Builder providedExpirationSecond(long providedExpirationSecond) {
            this.providedExpirationSecond = providedExpirationSecond;
            return this;
        }

        public Builder calculatedExpirationSecond(long calculatedExpirationSecond) {
            this.calculatedExpirationSecond = calculatedExpirationSecond;
            return this;
        }

        public Builder resolutionTime(@Nullable Timestamp resolutionTime) {
            this.resolutionTime = resolutionTime;
            return this;
        }

        public Builder resolutionTime(Timestamp.Builder builder) {
            this.resolutionTime = builder.build();
            return this;
        }

        public Builder scheduledTransaction(@Nullable SchedulableTransactionBody scheduledTransaction) {
            this.scheduledTransaction = scheduledTransaction;
            return this;
        }

        public Builder scheduledTransaction(SchedulableTransactionBody.Builder builder) {
            this.scheduledTransaction = builder.build();
            return this;
        }

        public Builder originalCreateTransaction(@Nullable TransactionBody originalCreateTransaction) {
            this.originalCreateTransaction = originalCreateTransaction;
            return this;
        }

        public Builder originalCreateTransaction(TransactionBody.Builder builder) {
            this.originalCreateTransaction = builder.build();
            return this;
        }

        public Builder signatories(@NonNull List<Key> signatories) {
            this.signatories = signatories != null ? signatories : Collections.emptyList();
            return this;
        }

        public Builder signatories(Key ... values) {
            this.signatories = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public ScheduleID scheduleId() {
            return this.scheduleId;
        }

        public boolean deleted() {
            return this.deleted;
        }

        public boolean executed() {
            return this.executed;
        }

        public boolean waitForExpiry() {
            return this.waitForExpiry;
        }

        public String memo() {
            return this.memo;
        }

        public AccountID schedulerAccountId() {
            return this.schedulerAccountId;
        }

        public AccountID payerAccountId() {
            return this.payerAccountId;
        }

        public Key adminKey() {
            return this.adminKey;
        }

        public Timestamp scheduleValidStart() {
            return this.scheduleValidStart;
        }

        public long providedExpirationSecond() {
            return this.providedExpirationSecond;
        }

        public long calculatedExpirationSecond() {
            return this.calculatedExpirationSecond;
        }

        public Timestamp resolutionTime() {
            return this.resolutionTime;
        }

        public SchedulableTransactionBody scheduledTransaction() {
            return this.scheduledTransaction;
        }

        public TransactionBody originalCreateTransaction() {
            return this.originalCreateTransaction;
        }

        public List<Key> signatories() {
            return this.signatories;
        }
    }
}

