/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec;

import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.node.app.service.contract.impl.annotations.QueryScope;
import com.hedera.node.app.service.contract.impl.exec.ActionSidecarContentTracer;
import com.hedera.node.app.service.contract.impl.exec.gas.CanonicalDispatchPrices;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.gas.TinybarValues;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.QueryHederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.QueryHederaOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.QuerySystemContractOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.SystemContractOperations;
import com.hedera.node.app.service.contract.impl.exec.tracers.EvmActionTracer;
import com.hedera.node.app.service.contract.impl.exec.utils.ActionStack;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmBlocks;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmContext;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.hevm.QueryContextHevmBlocks;
import com.hedera.node.app.service.contract.impl.state.EvmFrameStateFactory;
import com.hedera.node.app.service.contract.impl.state.EvmFrameStates;
import com.hedera.node.app.service.contract.impl.state.ProxyWorldUpdater;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.config.data.HederaConfig;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;
import org.hyperledger.besu.evm.code.CodeFactory;

@Module
public interface QueryModule {
    @Provides
    @QueryScope
    public static HederaConfig provideHederaConfig(@NonNull QueryContext context) {
        return (HederaConfig)Objects.requireNonNull(context).configuration().getConfigData(HederaConfig.class);
    }

    @Provides
    @QueryScope
    public static TinybarValues provideTinybarValues(@NonNull ExchangeRate exchangeRate) {
        return TinybarValues.forQueryWith(exchangeRate);
    }

    @Provides
    @QueryScope
    public static SystemContractGasCalculator provideSystemContractGasCalculator(@NonNull CanonicalDispatchPrices canonicalDispatchPrices, @NonNull TinybarValues tinybarValues) {
        return new SystemContractGasCalculator(tinybarValues, canonicalDispatchPrices, (body, payerId) -> {
            throw new IllegalStateException("Queries should fail before dispatching a child transaction");
        });
    }

    @Provides
    @QueryScope
    public static ExchangeRate provideExchangeRate(@NonNull Instant now, @NonNull QueryContext context) {
        return context.exchangeRateInfo().activeRate(now);
    }

    @Provides
    @QueryScope
    public static HederaWorldUpdater.Enhancement provideEnhancement(@NonNull HederaOperations operations, @NonNull HederaNativeOperations nativeOperations, @NonNull SystemContractOperations systemContractOperations) {
        return new HederaWorldUpdater.Enhancement(operations, nativeOperations, systemContractOperations);
    }

    @Provides
    @QueryScope
    public static ProxyWorldUpdater provideProxyWorldUpdater(@NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull EvmFrameStateFactory factory) {
        return new ProxyWorldUpdater(enhancement, Objects.requireNonNull(factory), null);
    }

    @Provides
    @QueryScope
    public static ActionSidecarContentTracer provideActionSidecarContentTracer() {
        return new EvmActionTracer(new ActionStack());
    }

    @Provides
    @QueryScope
    public static HederaEvmContext provideHederaEvmContext(@NonNull HederaOperations hederaOperations, @NonNull HederaEvmBlocks hederaEvmBlocks, @NonNull TinybarValues tinybarValues, @NonNull SystemContractGasCalculator systemContractGasCalculator) {
        return new HederaEvmContext(hederaOperations.gasPriceInTinybars(), true, hederaEvmBlocks, tinybarValues, systemContractGasCalculator, null, null);
    }

    @Binds
    @QueryScope
    public HederaOperations bindHederaOperations(QueryHederaOperations var1);

    @Binds
    @QueryScope
    public HederaNativeOperations bindHederaNativeOperations(QueryHederaNativeOperations var1);

    @Binds
    @QueryScope
    public HederaEvmBlocks bindHederaEvmBlocks(QueryContextHevmBlocks var1);

    @Binds
    @QueryScope
    public SystemContractOperations bindSystemContractOperations(QuerySystemContractOperations var1);

    @Provides
    @QueryScope
    public static EvmFrameStateFactory provideEvmFrameStateFactory(@NonNull CodeFactory codeFactory, @NonNull HederaOperations operations, @NonNull HederaNativeOperations nativeOperations) {
        return EvmFrameStates.DEFAULT.from(operations, nativeOperations, codeFactory);
    }
}

