/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractSource;
import io.helidon.config.AbstractSourceBuilder;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.FileSourceHelper;
import io.helidon.config.spi.ChangeWatcher;
import io.helidon.config.spi.ConfigContent;
import io.helidon.config.spi.OverrideSource;
import io.helidon.config.spi.PollableSource;
import io.helidon.config.spi.PollingStrategy;
import io.helidon.config.spi.WatchableSource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

public final class FileOverrideSource
extends AbstractSource
implements OverrideSource,
PollableSource<byte[]>,
WatchableSource<Path> {
    private static final System.Logger LOGGER = System.getLogger(FileOverrideSource.class.getName());
    private final Path filePath;

    FileOverrideSource(Builder builder) {
        super(builder);
        this.filePath = builder.path;
    }

    @Override
    protected String uid() {
        return this.filePath.toString();
    }

    @Override
    public boolean exists() {
        return Files.exists(this.filePath, new LinkOption[0]);
    }

    @Override
    public Optional<ConfigContent.OverrideContent> load() throws ConfigException {
        LOGGER.log(System.Logger.Level.DEBUG, String.format("Getting content from '%s'.", this.filePath));
        return FileSourceHelper.readDataAndDigest(this.filePath).map(dad -> ((ConfigContent.OverrideContent.Builder)ConfigContent.OverrideContent.builder().data(OverrideSource.OverrideData.create(new InputStreamReader((InputStream)new ByteArrayInputStream(dad.data()), StandardCharsets.UTF_8))).stamp(dad.digest())).build());
    }

    @Override
    public boolean isModified(byte[] stamp) {
        return FileSourceHelper.isModified(this.filePath, stamp);
    }

    @Override
    public Optional<PollingStrategy> pollingStrategy() {
        return super.pollingStrategy();
    }

    @Override
    public Path target() {
        return this.filePath;
    }

    @Override
    public Optional<ChangeWatcher<Object>> changeWatcher() {
        return super.changeWatcher();
    }

    @Override
    public Class<Path> targetType() {
        return Path.class;
    }

    public static FileOverrideSource create(Config metaConfig) {
        return FileOverrideSource.builder().config(metaConfig).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractSourceBuilder<Builder, Path>
    implements PollableSource.Builder<Builder>,
    WatchableSource.Builder<Builder, Path>,
    io.helidon.common.Builder<Builder, FileOverrideSource> {
        private Path path;

        private Builder() {
        }

        public FileOverrideSource build() {
            Objects.requireNonNull(this.path, "file path cannot be null");
            return new FileOverrideSource(this);
        }

        @Override
        public Builder config(Config metaConfig) {
            metaConfig.get("path").as(Path.class).ifPresent(this::path);
            return (Builder)super.config(metaConfig);
        }

        public Builder path(Path path) {
            this.path = path;
            return this;
        }

        @Override
        public Builder changeWatcher(ChangeWatcher<Path> changeWatcher) {
            return (Builder)super.changeWatcher(changeWatcher);
        }

        @Override
        public Builder pollingStrategy(PollingStrategy pollingStrategy) {
            return (Builder)super.pollingStrategy(pollingStrategy);
        }
    }
}

