/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.concurrent.pool;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.hiero.base.concurrent.ThrowingRunnable;
import org.hiero.consensus.concurrent.framework.Stoppable;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.concurrent.pool.ParallelExecutionException;
import org.hiero.consensus.concurrent.pool.ParallelExecutor;

public class CachedPoolParallelExecutor
implements ParallelExecutor,
Stoppable {
    private static final Runnable NOOP = () -> {};
    private ExecutorService threadPool;
    private boolean immutable = false;
    private final ThreadFactory factory;

    public CachedPoolParallelExecutor(@NonNull ThreadManager threadManager, String name) {
        this.factory = threadManager.createThreadFactory("parallel-executor", name);
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    @Override
    public void start() {
        this.throwIfImmutable("should only be started once");
        this.immutable = true;
        this.threadPool = Executors.newCachedThreadPool(this.factory);
    }

    @Override
    public boolean stop() {
        return this.stop(Stoppable.StopBehavior.BLOCKING);
    }

    @Override
    public boolean stop(Stoppable.StopBehavior behavior) {
        if (behavior == Stoppable.StopBehavior.BLOCKING) {
            this.threadPool.close();
        } else {
            this.threadPool.shutdownNow();
        }
        return true;
    }

    @Override
    public boolean pause() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean resume() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void join() throws InterruptedException {
        this.threadPool.close();
    }

    @Override
    public void join(long millis) throws InterruptedException {
        this.threadPool.shutdown();
        this.threadPool.awaitTermination(millis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void join(long millis, int nanos) throws InterruptedException {
        this.join(millis + (long)(nanos / 100000));
    }

    @Override
    public <T> T doParallelWithHandler(Runnable errorHandler, Callable<T> foregroundTask, ThrowingRunnable ... backgroundTasks) throws ParallelExecutionException {
        this.throwIfMutable("must be started first");
        List<Future> futures = Arrays.stream(backgroundTasks).map(this.threadPool::submit).toList();
        ParallelExecutionException toThrow = null;
        T result = null;
        try {
            result = foregroundTask.call();
        }
        catch (Throwable e) {
            toThrow = new ParallelExecutionException(e);
            errorHandler.run();
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (toThrow == null) {
                    toThrow = new ParallelExecutionException(e);
                    errorHandler.run();
                    continue;
                }
                toThrow.addSuppressed(e);
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
        return result;
    }
}

