/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.event;

import com.hedera.hapi.platform.event.EventCore;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Iterator;
import java.util.function.Consumer;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.transaction.Transaction;

public interface Event {
    public Iterator<Transaction> transactionIterator();

    public Instant getTimeCreated();

    @NonNull
    public NodeId getCreatorId();

    default public void forEachTransaction(Consumer<Transaction> consumer) {
        Iterator<Transaction> transIt = this.transactionIterator();
        while (transIt.hasNext()) {
            consumer.accept(transIt.next());
        }
    }

    public long getBirthRound();

    @NonNull
    public EventCore getEventCore();

    @NonNull
    public Bytes getSignature();
}

