/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

final class CharSequenceView
implements CharSequence {
    private final CharSequence source;
    private final int start;
    private final int end;

    CharSequenceView(CharSequence source) {
        this(source, 0, source.length());
    }

    private CharSequenceView(CharSequence source, int start, int end) {
        this.source = source;
        this.start = start;
        this.end = end;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public char charAt(int index) {
        return this.source.charAt(this.start + index);
    }

    @Override
    public CharSequenceView subSequence(int start, int end) {
        return new CharSequenceView(this.source, this.start + start, this.start + end);
    }

    int lastArrayOpen(int fromIdx) {
        int i = this.start + fromIdx;
        while (this.source.charAt(i) != '[') {
            --i;
        }
        return i - this.start;
    }

    public boolean equals(Object obj) {
        CharSequenceView o = (CharSequenceView)obj;
        if (this.length() != o.length()) {
            return false;
        }
        int i = this.start;
        int oi = o.start;
        while (i < this.end) {
            if (this.source.charAt(i) != o.source.charAt(oi)) {
                return false;
            }
            ++i;
            ++oi;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        for (int i = this.start; i < this.end; ++i) {
            h = 31 * h + this.source.charAt(i);
        }
        return h;
    }

    @Override
    public String toString() {
        return this.source.subSequence(this.start, this.end).toString();
    }

    public long getFourCharLong(int index) {
        return CharSequenceView.fourCharLong(this.source, this.start + index);
    }

    public static long fourCharLong(CharSequence cs) {
        return CharSequenceView.fourCharLong(cs, 0);
    }

    private static long fourCharLong(CharSequence cs, int offset) {
        return (long)cs.charAt(offset) << 48 | (long)cs.charAt(offset + 1) << 32 | (long)cs.charAt(offset + 2) << 16 | (long)cs.charAt(offset + 3);
    }
}

