/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.config;

import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.sources.LegacyFileConfigSource;
import com.swirlds.platform.config.internal.ConfigMappings;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;

public class DefaultConfiguration {
    private DefaultConfiguration() {
    }

    @NonNull
    public static Configuration buildBasicConfiguration(@NonNull ConfigurationBuilder configurationBuilder) throws IOException {
        return DefaultConfiguration.buildBasicConfiguration(configurationBuilder, FileUtils.getAbsolutePath((String)"settings.txt"));
    }

    @NonNull
    public static Configuration buildBasicConfiguration(@NonNull ConfigurationBuilder configurationBuilder, @NonNull Path settingsPath) throws IOException {
        LegacyFileConfigSource settingsConfigSource = LegacyFileConfigSource.ofSettingsFile((Path)settingsPath);
        ConfigSource mappedSettingsConfigSource = ConfigMappings.addConfigMapping((ConfigSource)settingsConfigSource);
        configurationBuilder.autoDiscoverExtensions().withSource(mappedSettingsConfigSource);
        return configurationBuilder.build();
    }
}

