/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.ConnectionManager;
import com.swirlds.platform.network.connection.NotConnectedConnection;
import java.util.concurrent.locks.Condition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.locks.AutoClosableResourceLock;
import org.hiero.base.concurrent.locks.Locks;
import org.hiero.base.concurrent.locks.locked.LockedResource;

public class InboundConnectionManager
implements ConnectionManager {
    private static final Logger logger = LogManager.getLogger(InboundConnectionManager.class);
    private Connection currentConn = NotConnectedConnection.getSingleton();
    private final AutoClosableResourceLock<Connection> lock = Locks.createResourceLock((Object)this.currentConn);
    private final Condition newConnectionSignal = this.lock.newCondition();

    @Override
    public Connection waitForConnection() throws InterruptedException {
        if (!this.currentConn.connected()) {
            this.currentConn = this.waitForNewConnection();
        }
        return this.currentConn;
    }

    @Override
    public Connection getConnection() {
        return this.currentConn;
    }

    private Connection waitForNewConnection() throws InterruptedException {
        try (LockedResource lockedConn = this.lock.lock();){
            while (!((Connection)lockedConn.getResource()).connected()) {
                this.newConnectionSignal.await();
            }
            Connection connection = (Connection)lockedConn.getResource();
            return connection;
        }
    }

    @Override
    public void newConnection(Connection connection) throws InterruptedException {
        try (LockedResource lockedConn = this.lock.lockInterruptibly();){
            Connection old = (Connection)lockedConn.getResource();
            if (old.connected()) {
                logger.warn(LogMarker.SOCKET_EXCEPTIONS.getMarker(), "{} got new connection from {}, disconnecting old one", (Object)old.getSelfId(), (Object)old.getOtherId());
            }
            old.disconnect();
            lockedConn.setResource((Object)connection);
            this.newConnectionSignal.signalAll();
        }
    }

    @Override
    public boolean isOutbound() {
        return false;
    }
}

