/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.reconnect;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import com.swirlds.base.formatting.StringFormattingUtils;
import com.swirlds.base.time.Time;
import com.swirlds.common.merkle.synchronization.TeachingSynchronizer;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.ReconnectFinishPayload;
import com.swirlds.logging.legacy.payload.ReconnectStartPayload;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.metrics.ReconnectMetrics;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.reconnect.ReconnectStateException;
import com.swirlds.platform.reconnect.ReconnectStateLearner;
import com.swirlds.platform.state.service.PlatformStateUtils;
import com.swirlds.platform.state.signed.SigSet;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.merkle.VirtualMapState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.time.Duration;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public class ReconnectStateTeacher {
    private static final Logger logger = LogManager.getLogger(ReconnectStateTeacher.class);
    private final Connection connection;
    private final Duration reconnectSocketTimeout;
    private final TeacherTreeView<Long> teacherView;
    private final SigSet signatures;
    private final long signingWeight;
    private final Roster roster;
    private final Hash hash;
    private final NodeId selfId;
    private final NodeId otherId;
    private final long lastRoundReceived;
    private final Configuration configuration;
    private final ReconnectMetrics statistics;
    private int originalSocketTimeout;
    private final ThreadManager threadManager;
    private final Time time;

    public ReconnectStateTeacher(@NonNull Configuration configuration, @NonNull Time time, @NonNull ThreadManager threadManager, @NonNull Connection connection, @NonNull Duration reconnectSocketTimeout, @NonNull NodeId selfId, @NonNull NodeId otherId, long lastRoundReceived, @NonNull SignedState signedState, @NonNull ReconnectMetrics statistics) {
        this.time = Objects.requireNonNull(time);
        this.threadManager = Objects.requireNonNull(threadManager);
        this.connection = Objects.requireNonNull(connection);
        this.reconnectSocketTimeout = reconnectSocketTimeout;
        this.selfId = Objects.requireNonNull(selfId);
        this.otherId = Objects.requireNonNull(otherId);
        this.lastRoundReceived = lastRoundReceived;
        this.statistics = Objects.requireNonNull(statistics);
        this.configuration = Objects.requireNonNull(configuration);
        this.signatures = signedState.getSigSet();
        this.signingWeight = signedState.getSigningWeight();
        this.roster = signedState.getRoster();
        this.hash = signedState.getState().getHash();
        MerkleNodeState merkleNodeState = signedState.getState();
        if (!(merkleNodeState instanceof VirtualMapState)) {
            throw new UnsupportedOperationException("Reconnects are only supported for VirtualMap states");
        }
        VirtualMapState virtualMapState = (VirtualMapState)merkleNodeState;
        ReconnectConfig reconnectConfig = (ReconnectConfig)configuration.getConfigData(ReconnectConfig.class);
        this.teacherView = virtualMapState.getRoot().buildTeacherView(reconnectConfig);
        this.logReconnectStart(signedState);
    }

    private void increaseSocketTimeout() throws ReconnectStateException {
        try {
            this.originalSocketTimeout = this.connection.getTimeout();
            this.connection.setTimeout(this.reconnectSocketTimeout.toMillis());
        }
        catch (SocketException e) {
            throw new ReconnectStateException(e);
        }
    }

    private void resetSocketTimeout() throws ReconnectStateException {
        if (!this.connection.connected()) {
            logger.debug(LogMarker.RECONNECT.getMarker(), "{} connection to {} is no longer connected. Returning.", (Object)this.connection.getSelfId(), (Object)this.connection.getOtherId());
            return;
        }
        try {
            this.connection.setTimeout(this.originalSocketTimeout);
        }
        catch (SocketException e) {
            throw new ReconnectStateException(e);
        }
    }

    public void execute() throws ReconnectStateException {
        if (!this.connection.connected()) {
            logger.debug(LogMarker.RECONNECT.getMarker(), "{} connection to {} is no longer connected. Returning.", (Object)this.connection.getSelfId(), (Object)this.connection.getOtherId());
            return;
        }
        this.increaseSocketTimeout();
        try {
            this.sendSignatures();
            this.reconnect();
            ReconnectStateLearner.endReconnectHandshake(this.connection);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ReconnectStateException(e);
        }
        catch (IOException e) {
            throw new ReconnectStateException(e);
        }
        finally {
            this.resetSocketTimeout();
        }
        this.logReconnectFinish();
    }

    private void logReconnectStart(SignedState signedState) {
        logger.info(LogMarker.RECONNECT.getMarker(), () -> new ReconnectStartPayload("Starting reconnect in the role of the sender", false, this.selfId.id(), this.otherId.id(), this.lastRoundReceived));
        StateConfig stateConfig = (StateConfig)this.configuration.getConfigData(StateConfig.class);
        logger.info(LogMarker.RECONNECT.getMarker(), "The following state will be sent to the learner:\n{}", new Supplier[]{() -> PlatformStateUtils.getInfoString((State)signedState.getState(), stateConfig.debugHashDepth())});
    }

    private void logReconnectFinish() {
        logger.info(LogMarker.RECONNECT.getMarker(), () -> new ReconnectFinishPayload("Finished reconnect in the role of the sender.", false, this.selfId.id(), this.otherId.id(), this.lastRoundReceived));
    }

    private void reconnect() throws InterruptedException, IOException {
        logger.info(LogMarker.RECONNECT.getMarker(), "Starting synchronization in the role of the sender.");
        this.statistics.incrementSenderStartTimes();
        this.connection.getDis().getSyncByteCounter().resetCount();
        this.connection.getDos().getSyncByteCounter().resetCount();
        ReconnectConfig reconnectConfig = (ReconnectConfig)this.configuration.getConfigData(ReconnectConfig.class);
        TeachingSynchronizer synchronizer = new TeachingSynchronizer(this.time, this.threadManager, new SerializableDataInputStream((InputStream)((Object)this.connection.getDis())), new SerializableDataOutputStream((OutputStream)((Object)this.connection.getDos())), this.teacherView, this.connection::disconnect, reconnectConfig);
        synchronizer.synchronize();
        this.connection.getDos().flush();
        this.statistics.incrementSenderEndTimes();
        logger.info(LogMarker.RECONNECT.getMarker(), "Finished synchronization in the role of the sender.");
    }

    private void sendSignatures() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("Sending signatures from nodes ");
        StringFormattingUtils.formattedList((StringBuilder)sb, this.signatures.iterator());
        sb.append(" (signing weight = ").append(this.signingWeight).append("/").append(RosterUtils.computeTotalWeight((Roster)this.roster)).append(") for state hash ").append(this.hash);
        logger.info(LogMarker.RECONNECT.getMarker(), (CharSequence)sb);
        WritableStreamingData wsd = new WritableStreamingData((OutputStream)((Object)this.connection.getDos()));
        this.signatures.serialize(wsd);
        this.connection.getDos().flush();
    }
}

