/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks;

import com.hedera.node.app.blocks.schemas.V0560BlockStreamSchema;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.SchemaRegistry;
import com.swirlds.state.lifecycle.Service;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockStreamService
implements Service {
    private static final Logger log = LogManager.getLogger(BlockStreamService.class);
    public static final String NAME = "BlockStreamService";
    @Nullable
    private Bytes migratedLastBlockHash;

    @NonNull
    public String getServiceName() {
        return NAME;
    }

    public void registerSchemas(@NonNull SchemaRegistry registry) {
        Objects.requireNonNull(registry);
        registry.register((Schema)new V0560BlockStreamSchema(this::setMigratedLastBlockHash));
    }

    public Optional<Bytes> migratedLastBlockHash() {
        return Optional.ofNullable(this.migratedLastBlockHash);
    }

    public void resetMigratedLastBlockHash() {
        this.migratedLastBlockHash = null;
    }

    private void setMigratedLastBlockHash(@NonNull Bytes migratedLastBlockHash) {
        this.migratedLastBlockHash = Objects.requireNonNull(migratedLastBlockHash);
        log.info("Migrated last block hash '{}'", (Object)migratedLastBlockHash);
    }
}

