/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.mapper;

import io.helidon.common.Weight;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.mapper.spi.MapperProvider;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;

@Weight(value=10.0)
class BuiltInMappers
implements MapperProvider {
    private static final Map<ClassPair, Mapper<?, ?>> MAPPERS;

    BuiltInMappers() {
    }

    private static <T> void addStringMapper(Map<ClassPair, Mapper<?, ?>> mappers, Class<T> targetType, Function<String, T> mapperFx) {
        Mapper<String, Object> mapper = mapperFx::apply;
        mappers.put(new ClassPair(String.class, targetType), mapper);
    }

    private static Byte asByte(String stringValue) {
        return Byte.parseByte(stringValue);
    }

    private static Short asShort(String stringValue) {
        return Short.parseShort(stringValue);
    }

    private static Integer asInt(String stringValue) {
        return Integer.parseInt(stringValue);
    }

    private static Long asLong(String stringValue) {
        return Long.parseLong(stringValue);
    }

    private static Float asFloat(String stringValue) {
        return Float.valueOf(Float.parseFloat(stringValue));
    }

    private static Double asDouble(String stringValue) {
        return Double.parseDouble(stringValue);
    }

    private static Boolean asBoolean(String stringValue) {
        String lower;
        return switch (lower = stringValue.toLowerCase()) {
            case "true", "1", "yes", "y", "on" -> true;
            default -> false;
        };
    }

    private static Character asChar(String stringValue) {
        if (stringValue.length() != 1) {
            throw new IllegalArgumentException("Cannot convert to 'char'. The value must be just single character, but was '" + stringValue + "'.");
        }
        return Character.valueOf(stringValue.charAt(0));
    }

    private static Class<?> asClass(String stringValue) {
        try {
            return Class.forName(stringValue);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static URL asUrl(String stringValue) {
        try {
            return URI.create(stringValue).toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public MapperProvider.ProviderResponse mapper(Class<?> sourceClass, Class<?> targetClass, String qualifier) {
        if (!qualifier.isEmpty()) {
            return MapperProvider.ProviderResponse.unsupported();
        }
        Mapper<?, ?> mapper = MAPPERS.get(new ClassPair(sourceClass, targetClass));
        if (mapper != null) {
            return new MapperProvider.ProviderResponse(MapperProvider.Support.SUPPORTED, mapper);
        }
        if (targetClass.equals(String.class)) {
            return new MapperProvider.ProviderResponse(MapperProvider.Support.COMPATIBLE, String::valueOf);
        }
        return MapperProvider.ProviderResponse.unsupported();
    }

    static {
        HashMap mappers = new HashMap();
        BuiltInMappers.addStringMapper(mappers, Boolean.class, BuiltInMappers::asBoolean);
        BuiltInMappers.addStringMapper(mappers, Boolean.TYPE, BuiltInMappers::asBoolean);
        BuiltInMappers.addStringMapper(mappers, Byte.class, BuiltInMappers::asByte);
        BuiltInMappers.addStringMapper(mappers, Byte.TYPE, BuiltInMappers::asByte);
        BuiltInMappers.addStringMapper(mappers, Short.class, BuiltInMappers::asShort);
        BuiltInMappers.addStringMapper(mappers, Short.TYPE, BuiltInMappers::asShort);
        BuiltInMappers.addStringMapper(mappers, Integer.class, BuiltInMappers::asInt);
        BuiltInMappers.addStringMapper(mappers, Integer.TYPE, BuiltInMappers::asInt);
        BuiltInMappers.addStringMapper(mappers, Long.class, BuiltInMappers::asLong);
        BuiltInMappers.addStringMapper(mappers, Long.TYPE, BuiltInMappers::asLong);
        BuiltInMappers.addStringMapper(mappers, Float.class, BuiltInMappers::asFloat);
        BuiltInMappers.addStringMapper(mappers, Float.TYPE, BuiltInMappers::asFloat);
        BuiltInMappers.addStringMapper(mappers, Double.class, BuiltInMappers::asDouble);
        BuiltInMappers.addStringMapper(mappers, Double.TYPE, BuiltInMappers::asDouble);
        BuiltInMappers.addStringMapper(mappers, Character.class, BuiltInMappers::asChar);
        BuiltInMappers.addStringMapper(mappers, Character.TYPE, BuiltInMappers::asChar);
        BuiltInMappers.addStringMapper(mappers, Class.class, BuiltInMappers::asClass);
        BuiltInMappers.addStringMapper(mappers, BigDecimal.class, BigDecimal::new);
        BuiltInMappers.addStringMapper(mappers, BigInteger.class, BigInteger::new);
        BuiltInMappers.addStringMapper(mappers, File.class, File::new);
        BuiltInMappers.addStringMapper(mappers, Path.class, x$0 -> Paths.get(x$0, new String[0]));
        BuiltInMappers.addStringMapper(mappers, Charset.class, Charset::forName);
        BuiltInMappers.addStringMapper(mappers, URI.class, URI::create);
        BuiltInMappers.addStringMapper(mappers, URL.class, BuiltInMappers::asUrl);
        BuiltInMappers.addStringMapper(mappers, Pattern.class, Pattern::compile);
        BuiltInMappers.addStringMapper(mappers, UUID.class, UUID::fromString);
        BuiltInMappers.addStringMapper(mappers, Duration.class, Duration::parse);
        BuiltInMappers.addStringMapper(mappers, Period.class, Period::parse);
        BuiltInMappers.addStringMapper(mappers, ZoneId.class, ZoneId::of);
        BuiltInMappers.addStringMapper(mappers, ZoneOffset.class, ZoneOffset::of);
        BuiltInMappers.addStringMapper(mappers, LocalDate.class, LocalDate::parse);
        BuiltInMappers.addStringMapper(mappers, LocalDateTime.class, LocalDateTime::parse);
        BuiltInMappers.addStringMapper(mappers, LocalTime.class, LocalTime::parse);
        BuiltInMappers.addStringMapper(mappers, ZonedDateTime.class, ZonedDateTime::parse);
        BuiltInMappers.addStringMapper(mappers, Instant.class, Instant::parse);
        BuiltInMappers.addStringMapper(mappers, OffsetTime.class, OffsetTime::parse);
        BuiltInMappers.addStringMapper(mappers, OffsetDateTime.class, OffsetDateTime::parse);
        BuiltInMappers.addStringMapper(mappers, YearMonth.class, YearMonth::parse);
        MAPPERS = Map.copyOf(mappers);
    }

    static final class ClassPair {
        private final Class<?> source;
        private final Class<?> target;

        ClassPair(Class<?> source, Class<?> target) {
            this.source = source;
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassPair classPair = (ClassPair)o;
            return this.source.equals(classPair.source) && this.target.equals(classPair.target);
        }

        public int hashCode() {
            return Objects.hash(this.source, this.target);
        }
    }
}

