/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.service.registry.ServiceRegistry;
import io.helidon.service.registry.ServiceRegistryConfig;
import io.helidon.service.registry.ServiceRegistryException;
import io.helidon.service.registry.ServiceRegistryManager;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public final class GlobalServiceRegistry {
    private static final String GLOBAL_CONTEXT_CLASSIFIER = "helidon-registry-static-context";
    private static final String GLOBAL_REGISTRY_CLASSIFIER = "helidon-registry";
    private static final ReadWriteLock RW_LOCK = new ReentrantReadWriteLock();

    private GlobalServiceRegistry() {
    }

    public static boolean configured() {
        return GlobalServiceRegistry.current().isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceRegistry registry() {
        Optional<ServiceRegistry> current = GlobalServiceRegistry.current();
        if (current.isPresent()) {
            return current.get();
        }
        RW_LOCK.writeLock().lock();
        try {
            current = GlobalServiceRegistry.current();
            if (current.isPresent()) {
                ServiceRegistry serviceRegistry = current.get();
                return serviceRegistry;
            }
            ServiceRegistryConfig config = ServiceRegistryConfig.create();
            ServiceRegistry newInstance = ServiceRegistryManager.create(config).registry();
            GlobalServiceRegistry.registry(newInstance);
            ServiceRegistry serviceRegistry = newInstance;
            return serviceRegistry;
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceRegistry registry(Supplier<ServiceRegistry> registrySupplier) {
        Optional<ServiceRegistry> current = GlobalServiceRegistry.current();
        if (current.isPresent()) {
            return current.get();
        }
        RW_LOCK.writeLock().lock();
        try {
            current = GlobalServiceRegistry.current();
            if (current.isPresent()) {
                ServiceRegistry serviceRegistry = current.get();
                return serviceRegistry;
            }
            ServiceRegistry newInstance = registrySupplier.get();
            if (newInstance == null) {
                throw new ServiceRegistryException("Global registry supplier cannot return null.");
            }
            GlobalServiceRegistry.registry(newInstance);
            ServiceRegistry serviceRegistry = newInstance;
            return serviceRegistry;
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    public static ServiceRegistry registry(ServiceRegistry newGlobalRegistry) {
        RW_LOCK.writeLock().lock();
        try {
            GlobalServiceRegistry.context().register((Object)GLOBAL_REGISTRY_CLASSIFIER, (Object)newGlobalRegistry);
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
        return newGlobalRegistry;
    }

    static void unset(ServiceRegistry registry) {
        RW_LOCK.writeLock().lock();
        try {
            GlobalServiceRegistry.context().unregister((Object)GLOBAL_REGISTRY_CLASSIFIER, (Object)registry);
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
    }

    private static Context context() {
        Context globalContext = Contexts.globalContext();
        return Contexts.context().orElse(globalContext).get((Object)GLOBAL_CONTEXT_CLASSIFIER, Context.class).orElse(globalContext);
    }

    private static Optional<ServiceRegistry> current() {
        RW_LOCK.readLock().lock();
        try {
            Optional optional = GlobalServiceRegistry.context().get((Object)GLOBAL_REGISTRY_CLASSIFIER, ServiceRegistry.class);
            return optional;
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }
}

