/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.common.nativesupport.api;

import com.hedera.common.nativesupport.NativeBinary;
import com.hedera.common.nativesupport.api.StreamAPI;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;

public class ProcessAPI
extends StreamAPI {
    private final Process process;

    public ProcessAPI(Class<?> clz, NativeBinary executableBinary) throws IOException {
        Path path = executableBinary.extract(clz);
        ProcessBuilder pb = new ProcessBuilder(new String[0]).command(path.toAbsolutePath().toString());
        this.process = pb.start();
    }

    @Override
    public void close() throws Exception {
        this.getOutputStream().close();
        this.getInputStream().close();
        this.getErrorStream().close();
        this.process.destroy();
    }

    @Override
    protected OutputStream getOutputStream() {
        return this.process.getOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.process.getInputStream();
    }

    public InputStream getErrorStream() {
        return this.process.getErrorStream();
    }
}

