/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.consensus.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.state.consensus.Topic;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.ConsensusServiceFeeBuilder;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.service.consensus.ReadableTopicStore;
import com.hedera.node.app.service.consensus.impl.WritableTopicStore;
import com.hedera.node.app.service.consensus.impl.validators.ConsensusCustomFeesValidator;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.validation.AttributeValidator;
import com.hedera.node.app.spi.validation.ExpiryMeta;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.TopicsConfig;
import com.hederahashgraph.api.proto.java.ConsensusUpdateTopicTransactionBody;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.Timestamp;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class ConsensusUpdateTopicHandler
implements TransactionHandler {
    private static final Logger log = LogManager.getLogger(ConsensusUpdateTopicHandler.class);
    private final ConsensusCustomFeesValidator customFeesValidator;

    @Inject
    public ConsensusUpdateTopicHandler(@NonNull ConsensusCustomFeesValidator customFeesValidator) {
        Objects.requireNonNull(customFeesValidator);
        this.customFeesValidator = customFeesValidator;
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody op = txn.consensusUpdateTopicOrThrow();
        PreCheckException.validateTruePreCheck((boolean)op.hasTopicID(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOPIC_ID);
        if (op.hasFeeExemptKeyList()) {
            long uniqueKeysCount = op.feeExemptKeyList().keys().stream().distinct().count();
            PreCheckException.validateTruePreCheck((uniqueKeysCount == (long)op.feeExemptKeyList().keys().size() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.FEE_EXEMPT_KEY_LIST_CONTAINS_DUPLICATED_KEYS);
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        AccountID autoRenewAccountID;
        Objects.requireNonNull(context);
        com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody op = context.body().consensusUpdateTopicOrThrow();
        ReadableTopicStore topicStore = (ReadableTopicStore)context.createStore(ReadableTopicStore.class);
        Topic topic = topicStore.getTopic(op.topicIDOrElse(TopicID.DEFAULT));
        Validations.mustExist((Object)topic, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOPIC_ID);
        PreCheckException.validateFalsePreCheck((boolean)topic.deleted(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOPIC_ID);
        UpdateType updateType = this.classifyUpdate(op);
        switch (updateType.ordinal()) {
            case 0: 
            case 1: {
                return;
            }
            case 2: {
                context.requireKeyOrThrow(topic.adminKey(), ResponseCodeEnum.UNAUTHORIZED);
                break;
            }
            case 3: {
                PreCheckException.validateTruePreCheck((boolean)topic.hasFeeScheduleKey(), (ResponseCodeEnum)ResponseCodeEnum.FEE_SCHEDULE_KEY_NOT_SET);
                context.requireKey(topic.feeScheduleKeyOrThrow());
                break;
            }
            case 4: {
                context.requireKeyOrThrow(topic.adminKey(), ResponseCodeEnum.UNAUTHORIZED);
                PreCheckException.validateTruePreCheck((boolean)topic.hasFeeScheduleKey(), (ResponseCodeEnum)ResponseCodeEnum.FEE_SCHEDULE_KEY_NOT_SET);
                context.requireKey(topic.feeScheduleKeyOrThrow());
            }
        }
        if (op.hasAdminKey()) {
            context.requireKey(op.adminKeyOrThrow());
        }
        if (op.hasAutoRenewAccount() && !this.designatesAccountRemoval(autoRenewAccountID = op.autoRenewAccountOrThrow())) {
            context.requireKeyOrThrow(autoRenewAccountID, ResponseCodeEnum.INVALID_AUTORENEW_ACCOUNT);
        }
    }

    public void handle(@NonNull HandleContext handleContext) {
        boolean removesAdminKey;
        Objects.requireNonNull(handleContext);
        TransactionBody txn = handleContext.body();
        com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody op = txn.consensusUpdateTopicOrThrow();
        WritableTopicStore topicStore = (WritableTopicStore)handleContext.storeFactory().writableStore(WritableTopicStore.class);
        Topic topic = Objects.requireNonNull(topicStore.getTopic(op.topicIDOrElse(TopicID.DEFAULT)));
        boolean bl = removesAdminKey = op.hasAdminKey() && KeyUtils.isEmpty((com.hedera.hapi.node.base.Key)op.adminKey());
        if (removesAdminKey) {
            boolean addsAutoRenewAccount = op.hasAutoRenewAccount() && !this.designatesAccountRemoval(op.autoRenewAccountOrThrow());
            boolean removesAutoRenewAccount = op.hasAutoRenewAccount() && this.designatesAccountRemoval(op.autoRenewAccountOrThrow());
            boolean endsWithAutoRenewAccount = addsAutoRenewAccount || topic.hasAutoRenewAccountId() && !removesAutoRenewAccount;
            HandleException.validateFalse((boolean)endsWithAutoRenewAccount, (ResponseCodeEnum)ResponseCodeEnum.AUTORENEW_ACCOUNT_NOT_ALLOWED);
        }
        this.validateMaybeNewAttributes(handleContext, op, topic);
        Topic.Builder builder = topic.copyBuilder();
        ExpiryMeta currentMeta = new ExpiryMeta(topic.expirationSecond(), topic.autoRenewPeriod(), topic.autoRenewAccountId());
        this.resolveMutableBuilderAttributes(handleContext, op, builder, currentMeta);
        topicStore.put(builder.build());
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        TransactionBody op = feeContext.body();
        com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody topicUpdate = op.consensusUpdateTopicOrElse(com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody.DEFAULT);
        TopicID topicId = topicUpdate.topicIDOrElse(TopicID.DEFAULT);
        Topic topic = ((ReadableTopicStore)feeContext.readableStore(ReadableTopicStore.class)).getTopic(topicId);
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(sigValueObj -> this.usageGivenExplicit(op, (SigValueObj)sigValueObj, topic));
    }

    private void resolveMutableBuilderAttributes(@NonNull HandleContext handleContext, @NonNull com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody op, @NonNull Topic.Builder builder, @NonNull ExpiryMeta currentExpiryMeta) {
        if (op.hasAdminKey()) {
            com.hedera.hapi.node.base.Key key = op.adminKey();
            if (AttributeValidator.isImmutableKey((com.hedera.hapi.node.base.Key)key)) {
                builder.adminKey((com.hedera.hapi.node.base.Key)null);
            } else {
                builder.adminKey(key);
            }
        }
        if (op.hasSubmitKey()) {
            com.hedera.hapi.node.base.Key newSubmitKey = op.submitKeyOrThrow();
            if (AttributeValidator.isKeyRemoval((com.hedera.hapi.node.base.Key)newSubmitKey)) {
                builder.submitKey((com.hedera.hapi.node.base.Key)null);
            } else {
                builder.submitKey(newSubmitKey);
            }
        }
        if (op.hasMemo()) {
            builder.memo(op.memo());
        }
        ExpiryMeta resolvedExpiryMeta = this.resolvedUpdateMetaFrom(handleContext.expiryValidator(), op, currentExpiryMeta);
        builder.expirationSecond(resolvedExpiryMeta.expiry());
        builder.autoRenewPeriod(resolvedExpiryMeta.autoRenewPeriod());
        if (op.hasAutoRenewAccount() && this.designatesAccountRemoval(op.autoRenewAccount())) {
            builder.autoRenewAccountId((AccountID)null);
        } else {
            builder.autoRenewAccountId(resolvedExpiryMeta.autoRenewAccountId());
        }
        if (op.hasFeeScheduleKey()) {
            com.hedera.hapi.node.base.Key newFeeScheduleKey = op.feeScheduleKey();
            if (AttributeValidator.isKeyRemoval((com.hedera.hapi.node.base.Key)newFeeScheduleKey)) {
                builder.feeScheduleKey((com.hedera.hapi.node.base.Key)null);
            } else {
                builder.feeScheduleKey(newFeeScheduleKey);
            }
        }
        if (op.hasFeeExemptKeyList()) {
            builder.feeExemptKeyList(op.feeExemptKeyList().keys());
        }
        if (op.hasCustomFees()) {
            builder.customFees(op.customFees().fees());
        }
    }

    private void validateMaybeNewAttributes(@NonNull HandleContext handleContext, @NonNull com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody op, @NonNull Topic topic) {
        AttributeValidator attributeValidator = handleContext.attributeValidator();
        this.validateMaybeNewAdminKey(attributeValidator, op);
        this.validateMaybeNewSubmitKey(attributeValidator, op);
        this.validateMaybeNewMemo(attributeValidator, op);
        this.validateMaybeNewFeeScheduleKey(attributeValidator, op, topic);
        this.validateMaybeFeeExemptKeyList(handleContext, attributeValidator, op);
        this.validateMaybeCustomFees(handleContext, op);
    }

    private ExpiryMeta resolvedUpdateMetaFrom(@NonNull ExpiryValidator expiryValidator, @NonNull com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody op, @NonNull ExpiryMeta currentMeta) {
        if (this.updatesExpiryMeta(op)) {
            ExpiryMeta updateMeta = new ExpiryMeta(this.effExpiryOf(op), this.effAutoRenewPeriodOf(op), op.autoRenewAccount());
            try {
                return expiryValidator.resolveUpdateAttempt(currentMeta, updateMeta);
            }
            catch (HandleException e) {
                if (e.getStatus() == ResponseCodeEnum.INVALID_RENEWAL_PERIOD) {
                    throw new HandleException(ResponseCodeEnum.AUTORENEW_DURATION_NOT_IN_RANGE);
                }
                throw e;
            }
        }
        return currentMeta;
    }

    private long effExpiryOf(@NonNull com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody op) {
        return op.hasExpirationTime() ? op.expirationTimeOrThrow().seconds() : ExpiryMeta.NA;
    }

    private long effAutoRenewPeriodOf(@NonNull com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody op) {
        return op.hasAutoRenewPeriod() ? op.autoRenewPeriodOrThrow().seconds() : ExpiryMeta.NA;
    }

    private boolean updatesExpiryMeta(@NonNull com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody op) {
        return op.expirationTime() != null || op.autoRenewPeriod() != null || op.autoRenewAccount() != null;
    }

    private void validateMaybeNewMemo(@NonNull AttributeValidator attributeValidator, @NonNull com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody op) {
        if (op.hasMemo()) {
            attributeValidator.validateMemo(op.memo());
        }
    }

    private void validateMaybeNewAdminKey(@NonNull AttributeValidator attributeValidator, @NonNull com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody op) {
        if (op.hasAdminKey() && !AttributeValidator.isImmutableKey((com.hedera.hapi.node.base.Key)op.adminKey())) {
            attributeValidator.validateKey(op.adminKey());
        }
    }

    private void validateMaybeNewSubmitKey(@NonNull AttributeValidator attributeValidator, @NonNull com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody op) {
        com.hedera.hapi.node.base.Key newSubmitKey;
        if (op.hasSubmitKey() && (!KeyUtils.isEmpty((com.hedera.hapi.node.base.Key)(newSubmitKey = op.submitKeyOrThrow())) || com.hedera.hapi.node.base.Key.DEFAULT.equals((Object)newSubmitKey))) {
            attributeValidator.validateKey(op.submitKeyOrThrow());
        }
    }

    private void validateMaybeNewFeeScheduleKey(@NonNull AttributeValidator attributeValidator, @NonNull com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody op, @NonNull Topic topic) {
        if (op.hasFeeScheduleKey()) {
            HandleException.validateTrue((boolean)topic.hasFeeScheduleKey(), (ResponseCodeEnum)ResponseCodeEnum.FEE_SCHEDULE_KEY_CANNOT_BE_UPDATED);
            if (!KeyUtils.isEmpty((com.hedera.hapi.node.base.Key)op.feeScheduleKey())) {
                attributeValidator.validateKey(op.feeScheduleKey(), ResponseCodeEnum.INVALID_CUSTOM_FEE_SCHEDULE_KEY);
            }
        }
    }

    private void validateMaybeFeeExemptKeyList(@NonNull HandleContext handleContext, @NonNull AttributeValidator attributeValidator, @NonNull com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody op) {
        if (!op.hasFeeExemptKeyList()) {
            return;
        }
        Configuration configuration = handleContext.configuration();
        TopicsConfig topicConfig = (TopicsConfig)configuration.getConfigData(TopicsConfig.class);
        List keys = op.feeExemptKeyListOrThrow().keys();
        HandleException.validateTrue((keys.size() <= topicConfig.maxEntriesForFeeExemptKeyList() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_ENTRIES_FOR_FEE_EXEMPT_KEY_LIST_EXCEEDED);
        keys.forEach(key -> attributeValidator.validateKey(key, ResponseCodeEnum.INVALID_KEY_IN_FEE_EXEMPT_KEY_LIST));
    }

    private void validateMaybeCustomFees(@NonNull HandleContext handleContext, @NonNull com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody op) {
        if (!op.hasCustomFees()) {
            return;
        }
        Configuration configuration = handleContext.configuration();
        TopicsConfig topicConfig = (TopicsConfig)configuration.getConfigData(TopicsConfig.class);
        ReadableAccountStore accountStore = (ReadableAccountStore)handleContext.storeFactory().readableStore(ReadableAccountStore.class);
        ReadableTokenStore tokenStore = (ReadableTokenStore)handleContext.storeFactory().readableStore(ReadableTokenStore.class);
        ReadableTokenRelationStore tokenRelStore = (ReadableTokenRelationStore)handleContext.storeFactory().readableStore(ReadableTokenRelationStore.class);
        HandleException.validateTrue((op.customFees().fees().size() <= topicConfig.maxCustomFeeEntriesForTopics() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEES_LIST_TOO_LONG);
        this.customFeesValidator.validate(accountStore, tokenRelStore, tokenStore, op.customFees().fees(), handleContext.expiryValidator());
    }

    private boolean designatesAccountRemoval(AccountID id) {
        return id.hasAccountNum() && id.accountNum() == 0L && id.alias() == null;
    }

    private FeeData usageGivenExplicit(@NonNull TransactionBody txnBody, @NonNull SigValueObj sigUsage, @Nullable Topic topic) {
        long rbsIncrease = 0L;
        com.hederahashgraph.api.proto.java.TransactionBody protoTxnBody = CommonPbjConverters.fromPbj((TransactionBody)txnBody);
        if (topic != null && topic.hasAdminKey()) {
            Timestamp expiry = Timestamp.newBuilder().setSeconds(topic.expirationSecond()).build();
            try {
                rbsIncrease = ConsensusServiceFeeBuilder.getUpdateTopicRbsIncrease((Timestamp)protoTxnBody.getTransactionID().getTransactionValidStart(), (Key)CommonPbjConverters.fromPbj((com.hedera.hapi.node.base.Key)topic.adminKeyOrElse(com.hedera.hapi.node.base.Key.DEFAULT)), (Key)CommonPbjConverters.fromPbj((com.hedera.hapi.node.base.Key)topic.submitKeyOrElse(com.hedera.hapi.node.base.Key.DEFAULT)), (String)topic.memo(), (boolean)topic.hasAutoRenewAccountId(), (Timestamp)expiry, (ConsensusUpdateTopicTransactionBody)protoTxnBody.getConsensusUpdateTopic());
            }
            catch (Exception e) {
                log.warn("Usage estimation unexpectedly failed for {}!", (Object)txnBody, (Object)e);
            }
        }
        return ConsensusServiceFeeBuilder.getConsensusUpdateTopicFee((com.hederahashgraph.api.proto.java.TransactionBody)protoTxnBody, (long)rbsIncrease, (SigValueObj)sigUsage);
    }

    private UpdateType classifyUpdate(@NonNull com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody op) {
        boolean hasAdminManaged;
        boolean hasExpiry = op.hasExpirationTime();
        boolean hasFeeScheduleManaged = op.hasCustomFees();
        boolean bl = hasAdminManaged = !op.equals((Object)com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody.newBuilder().topicID(op.topicID()).expirationTime(op.expirationTime()).customFees(op.customFees()).build());
        if (hasFeeScheduleManaged || hasAdminManaged) {
            if (hasFeeScheduleManaged && hasAdminManaged) {
                return UpdateType.ADMIN_AND_FEE_SCHEDULE_MANAGED;
            }
            if (hasFeeScheduleManaged) {
                return UpdateType.FEE_SCHEDULE_MANAGED_ONLY;
            }
            return UpdateType.ADMIN_MANAGED_ONLY;
        }
        return hasExpiry ? UpdateType.EXPIRY_ONLY : UpdateType.NOOP;
    }

    private static enum UpdateType {
        NOOP,
        EXPIRY_ONLY,
        ADMIN_MANAGED_ONLY,
        FEE_SCHEDULE_MANAGED_ONLY,
        ADMIN_AND_FEE_SCHEDULE_MANAGED;

    }
}

