/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class VirtualReconnectUtils {
    public static int completelyRead(InputStream in, byte[] dst) throws IOException {
        int totalBytesRead;
        int bytesRead;
        for (totalBytesRead = 0; totalBytesRead < dst.length && (bytesRead = in.read(dst, totalBytesRead, dst.length - totalBytesRead)) >= 0; totalBytesRead += bytesRead) {
        }
        return totalBytesRead;
    }

    public static VirtualLeafBytes readLeafRecord(SerializableDataInputStream in) throws IOException {
        Bytes leafValue;
        long leafPath = in.readLong();
        int leafKeyLen = in.readInt();
        byte[] leafKeyBytes = new byte[leafKeyLen];
        in.readFully(leafKeyBytes, 0, leafKeyLen);
        Bytes leafKey = Bytes.wrap((byte[])leafKeyBytes);
        int leafValueLen = in.readInt();
        if (leafValueLen > 0) {
            byte[] leafValueBytes = new byte[leafValueLen];
            in.readFully(leafValueBytes, 0, leafValueLen);
            leafValue = Bytes.wrap((byte[])leafValueBytes);
        } else {
            leafValue = leafValueLen == 0 ? Bytes.EMPTY : Bytes.EMPTY;
        }
        return new VirtualLeafBytes(leafPath, leafKey, leafValue);
    }

    public static void writeLeafRecord(SerializableDataOutputStream out, VirtualLeafBytes leaf) throws IOException {
        out.writeLong(leaf.path());
        Bytes key = leaf.keyBytes();
        out.writeInt(Math.toIntExact(key.length()));
        key.writeTo((OutputStream)out);
        Bytes value = leaf.valueBytes();
        if (value != null) {
            out.writeInt(Math.toIntExact(value.length()));
            value.writeTo((OutputStream)out);
        } else {
            out.writeInt(-1);
        }
    }
}

