/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.internal;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.gui.GuiConstants;
import com.swirlds.platform.gui.GuiUtils;
import com.swirlds.platform.gui.components.ScrollableJPanel;
import com.swirlds.platform.gui.hashgraph.HashgraphGuiSource;
import com.swirlds.platform.gui.internal.BrowserWindowManager;
import com.swirlds.platform.gui.internal.SwirldMenu;
import com.swirlds.platform.gui.internal.WinTabAddresses;
import com.swirlds.platform.gui.internal.WinTabCalls;
import com.swirlds.platform.gui.internal.WinTabNetwork;
import com.swirlds.platform.gui.internal.WinTabPosts;
import com.swirlds.platform.gui.internal.WinTabSecurity;
import com.swirlds.platform.gui.internal.WinTabSwirlds;
import com.swirlds.platform.gui.model.InfoMember;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.hashgraph.impl.consensus.Consensus;
import org.hiero.consensus.model.node.NodeId;

public class WinBrowser
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(WinBrowser.class);
    final int refreshPeriod = 500;
    public static volatile InfoMember memberDisplayed = null;
    private boolean didInit = false;
    private static Timer updater = null;
    private static final int topGap = 40;
    static ScrollableJPanel tabSwirlds;
    static ScrollableJPanel tabAddresses;
    static ScrollableJPanel tabCalls;
    static ScrollableJPanel tabPosts;
    static ScrollableJPanel tabNetwork;
    static ScrollableJPanel tabSecurity;
    static JPanel nameBar;
    static JTextArea nameBarLabel;
    static JTextArea nameBarName;
    static JTabbedPane tabbed;

    @Override
    public void paintComponents(Graphics g) {
        super.paintComponents(g);
        Thread.currentThread().setPriority(10);
    }

    static synchronized void prePaintThenRepaint() {
        try {
            WinBrowser win;
            Component comp;
            if (memberDisplayed != null) {
                nameBarName.setText("    " + memberDisplayed.getName() + "    ");
            } else if (tabSwirlds != null) {
                ((WinTabSwirlds)tabSwirlds.getContents()).chooseMemberDisplayed();
            }
            if (tabbed != null && (comp = tabbed.getSelectedComponent()) != null && comp instanceof ScrollableJPanel) {
                ScrollableJPanel tabCurrent = (ScrollableJPanel)comp;
                tabCurrent.prePaint();
            }
            if ((win = BrowserWindowManager.getBrowserWindow()) != null) {
                if (!win.didInit && memberDisplayed != null && tabSwirlds != null && tabAddresses != null && tabCalls != null && tabPosts != null && tabNetwork != null && tabSecurity != null) {
                    win.didInit = true;
                    tabSwirlds.prePaint();
                    tabAddresses.prePaint();
                    tabCalls.prePaint();
                    tabPosts.prePaint();
                    tabNetwork.prePaint();
                    tabSecurity.prePaint();
                }
                win.repaint();
            }
        }
        catch (Exception e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "error while prepainting or painting: ", (Throwable)e);
        }
    }

    public WinBrowser(@NonNull NodeId firstNodeId, @NonNull HashgraphGuiSource hashgraphSource, @NonNull Consensus consensus, @NonNull Metrics guiMetrics) {
        ActionListener repaintPeriodically = new ActionListener(this){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WinBrowser.prePaintThenRepaint();
            }
        };
        nameBar = new JPanel();
        nameBarLabel = new JTextArea();
        nameBarName = new JTextArea();
        tabbed = new JTabbedPane(1, 0);
        tabSwirlds = GuiUtils.makeScrollableJPanel(new WinTabSwirlds());
        tabAddresses = GuiUtils.makeScrollableJPanel(new WinTabAddresses());
        tabCalls = GuiUtils.makeScrollableJPanel(new WinTabCalls());
        tabPosts = GuiUtils.makeScrollableJPanel(new WinTabPosts());
        tabNetwork = GuiUtils.makeScrollableJPanel(new WinTabNetwork(firstNodeId, hashgraphSource, consensus, guiMetrics));
        tabSecurity = GuiUtils.makeScrollableJPanel(new WinTabSecurity());
        Rectangle winRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.setDefaultCloseOperation(2);
        Dimension dim = new Dimension(winRect.width, winRect.height - 40);
        this.setSize(dim);
        this.setPreferredSize(dim);
        this.setLocation(winRect.x, winRect.y + 40);
        this.setFocusable(true);
        this.requestFocusInWindow();
        this.addWindowListener(GuiUtils.stopper());
        nameBar.setLayout(new GridBagLayout());
        nameBar.setPreferredSize(new Dimension(1000, 42));
        ClickForTabSwirlds listener = new ClickForTabSwirlds(this);
        nameBarLabel.setText("Displaying information for:  ");
        nameBarLabel.setEditable(false);
        nameBarLabel.setEnabled(false);
        nameBarLabel.setDisabledTextColor(Color.BLACK);
        nameBarLabel.addMouseListener(listener);
        nameBarLabel.setCaretPosition(0);
        nameBarName.setText("");
        nameBarName.setEditable(false);
        nameBarName.setEnabled(false);
        nameBarName.setDisabledTextColor(Color.BLACK);
        nameBarName.addMouseListener(listener);
        nameBar.add(nameBarLabel);
        nameBar.add(nameBarName);
        nameBar.addMouseListener(listener);
        tabbed.addTab("Swirlds", tabSwirlds);
        tabbed.addTab("Addresses", tabAddresses);
        tabbed.addTab("Network", tabNetwork);
        tabbed.addTab("Security", tabSecurity);
        this.goTab(tabNetwork);
        this.setBackground(Color.WHITE);
        nameBar.setBackground(Color.WHITE);
        nameBarLabel.setBackground(Color.WHITE);
        nameBarName.setBackground(GuiConstants.MEMBER_HIGHLIGHT_COLOR);
        tabbed.setBackground(Color.WHITE);
        tabbed.setForeground(Color.BLACK);
        this.setLayout(new BorderLayout());
        this.add((Component)nameBar, "First");
        this.add((Component)tabbed, "Center");
        SwirldMenu.addTo(null, this, 40);
        this.pack();
        this.setExtendedState(this.getExtendedState() | 6);
        this.setVisible(true);
        updater = new Timer(500, repaintPeriodically);
        updater.start();
    }

    public void goTab(ScrollableJPanel contents) {
        this.requestFocus(true);
        if (contents != null) {
            tabbed.setSelectedComponent(contents);
        }
        WinBrowser.prePaintThenRepaint();
    }

    private class ClickForTabSwirlds
    extends MouseAdapter {
        private ClickForTabSwirlds(WinBrowser winBrowser) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                BrowserWindowManager.showBrowserWindow(tabSwirlds);
            }
        }
    }
}

