/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.Pair;
import com.esaulpaugh.headlong.abi.Quadruple;
import com.esaulpaugh.headlong.abi.Quintuple;
import com.esaulpaugh.headlong.abi.Sextuple;
import com.esaulpaugh.headlong.abi.Single;
import com.esaulpaugh.headlong.abi.Triple;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.IntFunction;

public class Tuple
implements Iterable<Object> {
    public static final Tuple EMPTY = new Tuple(new Object[0]);
    final Object[] elements;

    Tuple(Object ... elements) {
        boolean permitted;
        Class<?> c = this.getClass();
        boolean bl = permitted = c == Tuple.class || c == Single.class || c == Pair.class || c == Triple.class || c == Quadruple.class || c == Quintuple.class || c == Sextuple.class;
        if (!permitted) {
            throw new IllegalStateException("unexpected subclass");
        }
        this.elements = elements;
    }

    public static <V> Single<V> singleton(V element) {
        return Single.of(element);
    }

    public static <A, B> Pair<A, B> of(A a, B b) {
        return new Pair(Tuple.requireNoNulls(new Object[]{a, b}));
    }

    public static <A, B, C> Triple<A, B, C> of(A a, B b, C c) {
        return new Triple(Tuple.requireNoNulls(new Object[]{a, b, c}));
    }

    public static <A, B, C, D> Quadruple<A, B, C, D> of(A a, B b, C c, D d) {
        return new Quadruple(Tuple.requireNoNulls(new Object[]{a, b, c, d}));
    }

    public static <A, B, C, D, E> Quintuple<A, B, C, D, E> of(A a, B b, C c, D d, E e) {
        return new Quintuple(Tuple.requireNoNulls(new Object[]{a, b, c, d, e}));
    }

    public static <A, B, C, D, E, F> Sextuple<A, B, C, D, E, F> of(A a, B b, C c, D d, E e, F f) {
        return new Sextuple(Tuple.requireNoNulls(new Object[]{a, b, c, d, e, f}));
    }

    public static <T extends Tuple> T from(Object ... elements) {
        return (T)Tuple.create(Tuple.copy(new Object[elements.length], i -> Tuple.requireNotNull(elements[i], i)));
    }

    static <J extends Tuple> J create(Object[] elements) {
        switch (elements.length) {
            case 1: {
                return (J)new Single(elements);
            }
            case 2: {
                return (J)new Pair(elements);
            }
            case 3: {
                return (J)new Triple(elements);
            }
            case 4: {
                return (J)new Quadruple(elements);
            }
            case 5: {
                return (J)new Quintuple(elements);
            }
            case 6: {
                return (J)new Sextuple(elements);
            }
        }
        return (J)new Tuple(elements);
    }

    static <J extends Tuple> Class<J> classFor(int len) {
        switch (len) {
            case 1: {
                return Single.class;
            }
            case 2: {
                return Pair.class;
            }
            case 3: {
                return Triple.class;
            }
            case 4: {
                return Quadruple.class;
            }
            case 5: {
                return Quintuple.class;
            }
            case 6: {
                return Sextuple.class;
            }
        }
        return Tuple.class;
    }

    private static Object[] requireNoNulls(Object[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            Tuple.requireNotNull(elements[i], i);
        }
        return elements;
    }

    static Object requireNotNull(Object e, int index) {
        if (e == null) {
            throw new IllegalArgumentException("tuple index " + index + " is null");
        }
        return e;
    }

    public final <T> T get(int index) {
        Object val = this.elements[index];
        if (val == null) {
            throw new NoSuchElementException("" + index);
        }
        return (T)val;
    }

    public final boolean elementIsPresent(int index) {
        return this.elements[index] != null;
    }

    public final int size() {
        return this.elements.length;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final int hashCode() {
        return Arrays.deepHashCode(this.elements);
    }

    public final boolean equals(Object o) {
        return o == this || o instanceof Tuple && Arrays.deepEquals(this.elements, ((Tuple)o).elements);
    }

    public final String toString() {
        return Arrays.deepToString(Tuple.copy(new Object[this.elements.length], i -> {
            Object element = this.elements[i];
            if (element == null) {
                return "_";
            }
            String str = element.toString();
            return element instanceof String ? '\"' + str + '\"' : ("_".equals(str) ? "\\_" : element);
        }));
    }

    private static Object[] copy(Object[] copy, IntFunction<Object> extractor) {
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = extractor.apply(i);
        }
        return copy;
    }

    @Override
    public final Iterator<Object> iterator() {
        return Arrays.asList(this.elements).iterator();
    }

    public final <J extends Tuple> J deepCopy() {
        return Tuple.create(Tuple.copy(new Object[this.elements.length], i -> Tuple.deepCopyElement(this.elements[i])));
    }

    public final Object[] toArray() {
        return Arrays.copyOf(this.elements, this.elements.length);
    }

    private static Object deepCopyElement(Object e) {
        Class<?> c = e.getClass();
        if (c.isArray()) {
            if (e instanceof Object[]) {
                Object[] original = (Object[])e;
                return Tuple.copy(ArrayType.createArray(c.getComponentType(), original.length), i -> Tuple.deepCopyElement(original[i]));
            }
            if (e instanceof byte[]) {
                byte[] bytes = (byte[])e;
                return Arrays.copyOf(bytes, bytes.length);
            }
            if (e instanceof int[]) {
                int[] ints = (int[])e;
                return Arrays.copyOf(ints, ints.length);
            }
            if (e instanceof long[]) {
                long[] longs = (long[])e;
                return Arrays.copyOf(longs, longs.length);
            }
            if (e instanceof boolean[]) {
                boolean[] booleans = (boolean[])e;
                return Arrays.copyOf(booleans, booleans.length);
            }
            throw new IllegalArgumentException();
        }
        return e instanceof Tuple ? ((Tuple)e).deepCopy() : e;
    }

    protected final void finalize() throws Throwable {
    }
}

