/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream;

import com.hedera.hapi.block.stream.AggregatedNodeSignatures;
import com.hedera.hapi.block.stream.SignedRecordFileProof;
import com.hedera.hapi.block.stream.StateProof;
import com.hedera.hapi.block.stream.TssSignedBlockProof;
import com.hedera.hapi.block.stream.codec.BlockProofJsonCodec;
import com.hedera.hapi.block.stream.codec.BlockProofProtoCodec;
import com.hedera.hapi.block.stream.schema.BlockProofSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class BlockProof {
    public static final Codec<BlockProof> PROTOBUF = new BlockProofProtoCodec();
    public static final JsonCodec<BlockProof> JSON = new BlockProofJsonCodec();
    public static final BlockProof DEFAULT = BlockProof.newBuilder().build();
    private final long block;
    private final OneOf<ProofOneOfType> proof;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public BlockProof(long block, OneOf<ProofOneOfType> proof) {
        this.$unknownFields = null;
        this.block = block;
        if (proof == null) {
            throw new NullPointerException("Parameter 'proof' must be supplied and can not be null");
        }
        this.proof = proof;
    }

    public BlockProof(long block, OneOf<ProofOneOfType> proof, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.block = block;
        if (proof == null) {
            throw new NullPointerException("Parameter 'proof' must be supplied and can not be null");
        }
        this.proof = proof;
    }

    public long block() {
        return this.block;
    }

    public OneOf<ProofOneOfType> proof() {
        return this.proof;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)BlockProofSchema.BLOCK, (long)this.block, (boolean)true);
            if (this.proof.kind() == ProofOneOfType.SIGNED_BLOCK_PROOF) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockProofSchema.SIGNED_BLOCK_PROOF, (Object)((TssSignedBlockProof)this.proof.as()), TssSignedBlockProof.PROTOBUF);
            }
            if (this.proof.kind() == ProofOneOfType.BLOCK_STATE_PROOF) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockProofSchema.BLOCK_STATE_PROOF, (Object)((StateProof)this.proof.as()), StateProof.PROTOBUF);
            }
            if (this.proof.kind() == ProofOneOfType.SIGNED_RECORD_FILE_PROOF) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockProofSchema.SIGNED_RECORD_FILE_PROOF, (Object)((SignedRecordFileProof)this.proof.as()), SignedRecordFileProof.PROTOBUF);
            }
            if (this.proof.kind() == ProofOneOfType.AGGREGATED_NODE_SIGNATURES) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockProofSchema.AGGREGATED_NODE_SIGNATURES, (Object)((AggregatedNodeSignatures)this.proof.as()), AggregatedNodeSignatures.PROTOBUF);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.block != BlockProof.DEFAULT.block) {
                result = 31 * result + Long.hashCode(this.block);
            }
            if (this.proof != null && !this.proof.equals(BlockProof.DEFAULT.proof)) {
                result = 31 * result + this.proof.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        BlockProof thatObj = (BlockProof)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.block != thatObj.block) {
            return false;
        }
        if (this.proof == null && thatObj.proof != null) {
            return false;
        }
        if (this.proof != null && !this.proof.equals(thatObj.proof)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "BlockProof[block=" + this.block + ", proof=" + String.valueOf(this.proof) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    @Nullable
    public TssSignedBlockProof signedBlockProof() {
        return this.proof.kind() == ProofOneOfType.SIGNED_BLOCK_PROOF ? (TssSignedBlockProof)this.proof.value() : null;
    }

    public boolean hasSignedBlockProof() {
        return this.proof.kind() == ProofOneOfType.SIGNED_BLOCK_PROOF;
    }

    public TssSignedBlockProof signedBlockProofOrElse(@NonNull TssSignedBlockProof defaultValue) {
        return this.hasSignedBlockProof() ? this.signedBlockProof() : defaultValue;
    }

    @NonNull
    public TssSignedBlockProof signedBlockProofOrThrow() {
        return Objects.requireNonNull(this.signedBlockProof(), "Field signedBlockProof is null");
    }

    @Nullable
    public StateProof blockStateProof() {
        return this.proof.kind() == ProofOneOfType.BLOCK_STATE_PROOF ? (StateProof)this.proof.value() : null;
    }

    public boolean hasBlockStateProof() {
        return this.proof.kind() == ProofOneOfType.BLOCK_STATE_PROOF;
    }

    public StateProof blockStateProofOrElse(@NonNull StateProof defaultValue) {
        return this.hasBlockStateProof() ? this.blockStateProof() : defaultValue;
    }

    @NonNull
    public StateProof blockStateProofOrThrow() {
        return Objects.requireNonNull(this.blockStateProof(), "Field blockStateProof is null");
    }

    @Nullable
    public SignedRecordFileProof signedRecordFileProof() {
        return this.proof.kind() == ProofOneOfType.SIGNED_RECORD_FILE_PROOF ? (SignedRecordFileProof)this.proof.value() : null;
    }

    public boolean hasSignedRecordFileProof() {
        return this.proof.kind() == ProofOneOfType.SIGNED_RECORD_FILE_PROOF;
    }

    public SignedRecordFileProof signedRecordFileProofOrElse(@NonNull SignedRecordFileProof defaultValue) {
        return this.hasSignedRecordFileProof() ? this.signedRecordFileProof() : defaultValue;
    }

    @NonNull
    public SignedRecordFileProof signedRecordFileProofOrThrow() {
        return Objects.requireNonNull(this.signedRecordFileProof(), "Field signedRecordFileProof is null");
    }

    @Nullable
    public AggregatedNodeSignatures aggregatedNodeSignatures() {
        return this.proof.kind() == ProofOneOfType.AGGREGATED_NODE_SIGNATURES ? (AggregatedNodeSignatures)this.proof.value() : null;
    }

    public boolean hasAggregatedNodeSignatures() {
        return this.proof.kind() == ProofOneOfType.AGGREGATED_NODE_SIGNATURES;
    }

    public AggregatedNodeSignatures aggregatedNodeSignaturesOrElse(@NonNull AggregatedNodeSignatures defaultValue) {
        return this.hasAggregatedNodeSignatures() ? this.aggregatedNodeSignatures() : defaultValue;
    }

    @NonNull
    public AggregatedNodeSignatures aggregatedNodeSignaturesOrThrow() {
        return Objects.requireNonNull(this.aggregatedNodeSignatures(), "Field aggregatedNodeSignatures is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.block, this.proof, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum ProofOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        SIGNED_BLOCK_PROOF(2, "signed_block_proof"),
        BLOCK_STATE_PROOF(3, "block_state_proof"),
        SIGNED_RECORD_FILE_PROOF(4, "signed_record_file_proof"),
        AGGREGATED_NODE_SIGNATURES(5, "aggregated_node_signatures");

        private final int protoOrdinal;
        private final String protoName;

        private ProofOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static ProofOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 2 -> SIGNED_BLOCK_PROOF;
                case 3 -> BLOCK_STATE_PROOF;
                case 4 -> SIGNED_RECORD_FILE_PROOF;
                case 5 -> AGGREGATED_NODE_SIGNATURES;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static ProofOneOfType fromString(String name) {
            return switch (name) {
                case "signed_block_proof", "SIGNED_BLOCK_PROOF" -> SIGNED_BLOCK_PROOF;
                case "block_state_proof", "BLOCK_STATE_PROOF" -> BLOCK_STATE_PROOF;
                case "signed_record_file_proof", "SIGNED_RECORD_FILE_PROOF" -> SIGNED_RECORD_FILE_PROOF;
                case "aggregated_node_signatures", "AGGREGATED_NODE_SIGNATURES" -> AGGREGATED_NODE_SIGNATURES;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private long block = 0L;
        private OneOf<ProofOneOfType> proof = BlockProofProtoCodec.PROOF_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(long block, OneOf<ProofOneOfType> proof) {
            this.$unknownFields = null;
            this.block = block;
            this.proof = proof;
        }

        public Builder(long block, OneOf<ProofOneOfType> proof, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.block = block;
            this.proof = proof;
        }

        public BlockProof build() {
            return new BlockProof(this.block, this.proof);
        }

        public Builder block(long block) {
            this.block = block;
            return this;
        }

        public void clearProof() {
            this.proof = BlockProofProtoCodec.PROOF_UNSET;
        }

        public Builder signedBlockProof(@Nullable TssSignedBlockProof signedBlockProof) {
            this.proof = new OneOf((Enum)ProofOneOfType.SIGNED_BLOCK_PROOF, (Object)signedBlockProof);
            return this;
        }

        public Builder signedBlockProof(TssSignedBlockProof.Builder builder) {
            this.proof = new OneOf((Enum)ProofOneOfType.SIGNED_BLOCK_PROOF, (Object)builder.build());
            return this;
        }

        public Builder blockStateProof(@Nullable StateProof blockStateProof) {
            this.proof = new OneOf((Enum)ProofOneOfType.BLOCK_STATE_PROOF, (Object)blockStateProof);
            return this;
        }

        public Builder blockStateProof(StateProof.Builder builder) {
            this.proof = new OneOf((Enum)ProofOneOfType.BLOCK_STATE_PROOF, (Object)builder.build());
            return this;
        }

        public Builder signedRecordFileProof(@Nullable SignedRecordFileProof signedRecordFileProof) {
            this.proof = new OneOf((Enum)ProofOneOfType.SIGNED_RECORD_FILE_PROOF, (Object)signedRecordFileProof);
            return this;
        }

        public Builder signedRecordFileProof(SignedRecordFileProof.Builder builder) {
            this.proof = new OneOf((Enum)ProofOneOfType.SIGNED_RECORD_FILE_PROOF, (Object)builder.build());
            return this;
        }

        public Builder aggregatedNodeSignatures(@Nullable AggregatedNodeSignatures aggregatedNodeSignatures) {
            this.proof = new OneOf((Enum)ProofOneOfType.AGGREGATED_NODE_SIGNATURES, (Object)aggregatedNodeSignatures);
            return this;
        }

        public Builder aggregatedNodeSignatures(AggregatedNodeSignatures.Builder builder) {
            this.proof = new OneOf((Enum)ProofOneOfType.AGGREGATED_NODE_SIGNATURES, (Object)builder.build());
            return this;
        }

        public long block() {
            return this.block;
        }

        public OneOf<ProofOneOfType> proof() {
            return this.proof;
        }
    }
}

