/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl.streaming;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public enum ConnectionState {
    UNINITIALIZED(0, false),
    READY(1, false),
    ACTIVE(2, false),
    CLOSING(3, true),
    CLOSED(4, true);

    private final int lifecycleStep;
    private final boolean isTerminal;

    private ConnectionState(int lifecycleStep, boolean isTerminal) {
        this.lifecycleStep = lifecycleStep;
        this.isTerminal = isTerminal;
    }

    public boolean isTerminal() {
        return this.isTerminal;
    }

    public boolean canTransitionTo(@NonNull ConnectionState newStatus) {
        Objects.requireNonNull(newStatus, "newStatus is required");
        return this.lifecycleStep <= newStatus.lifecycleStep;
    }
}

