/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state;

import com.hedera.node.app.state.ReadonlyStatesWrapper;
import com.hedera.node.app.state.WrappedWritableStates;
import com.swirlds.state.State;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Hashable;

public class WrappedState
implements State,
Hashable {
    private final State delegate;
    private final Map<String, WrappedWritableStates> writableStatesMap = new HashMap<String, WrappedWritableStates>();

    public WrappedState(@NonNull State delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate must not be null");
    }

    public boolean isModified() {
        for (WrappedWritableStates writableStates : this.writableStatesMap.values()) {
            if (!writableStates.isModified()) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public ReadableStates getReadableStates(@NonNull String serviceName) {
        return new ReadonlyStatesWrapper(this.getWritableStates(serviceName));
    }

    @NonNull
    public WritableStates getWritableStates(@NonNull String serviceName) {
        return this.writableStatesMap.computeIfAbsent(serviceName, s -> new WrappedWritableStates(this.delegate.getWritableStates(s)));
    }

    public void commit() {
        for (WrappedWritableStates writableStates : this.writableStatesMap.values()) {
            writableStates.commit(this.delegate.isStartUpMode());
        }
    }

    public void setHash(Hash hash) {
        this.delegate.setHash(hash);
    }

    public boolean isStartUpMode() {
        return this.delegate.isStartUpMode();
    }
}

