/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.dispatch;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.token.impl.handlers.FinalizeRecordHandler;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.workflows.handle.Dispatch;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RecordFinalizer {
    private final FinalizeRecordHandler recordFinalizer;

    @Inject
    public RecordFinalizer(FinalizeRecordHandler recordFinalizer) {
        this.recordFinalizer = recordFinalizer;
    }

    public void finalizeRecord(@NonNull Dispatch dispatch) {
        Objects.requireNonNull(dispatch);
        if (dispatch.stack().permitsStakingRewards()) {
            this.recordFinalizer.finalizeStakingRecord(dispatch.finalizeContext(), dispatch.txnInfo().functionality(), this.extraRewardReceivers(dispatch.txnInfo().txBody(), dispatch.txnInfo().functionality(), dispatch.streamBuilder()), dispatch.handleContext().dispatchPaidRewards());
        } else {
            this.recordFinalizer.finalizeNonStakingRecord(dispatch.finalizeContext(), dispatch.txnInfo().functionality());
        }
    }

    public Set<AccountID> extraRewardReceivers(@Nullable TransactionBody body, @NonNull HederaFunctionality function, @NonNull StreamBuilder recordBuilder) {
        if (body == null || recordBuilder.status() != ResponseCodeEnum.SUCCESS) {
            return Collections.emptySet();
        }
        return switch (function) {
            case HederaFunctionality.CRYPTO_TRANSFER -> this.zeroAdjustIdsFrom(body.cryptoTransferOrThrow().transfersOrElse(TransferList.DEFAULT).accountAmounts());
            case HederaFunctionality.ETHEREUM_TRANSACTION, HederaFunctionality.CONTRACT_CALL, HederaFunctionality.CONTRACT_CREATE -> recordBuilder.explicitRewardSituationIds();
            default -> Collections.emptySet();
        };
    }

    @NonNull
    Set<AccountID> zeroAdjustIdsFrom(@NonNull List<AccountAmount> explicitHbarAdjustments) {
        return explicitHbarAdjustments.stream().filter(aa -> aa.amount() == 0L).map(AccountAmount::accountID).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

