/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.sequence.set;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.ToLongFunction;
import org.hiero.consensus.model.sequence.map.SequenceMap;
import org.hiero.consensus.model.sequence.map.StandardSequenceMap;
import org.hiero.consensus.model.sequence.set.AbstractSequenceSet;

public class StandardSequenceSet<T>
extends AbstractSequenceSet<T> {
    public StandardSequenceSet(long lowestAllowedSequenceNumber, int sequenceNumberCapacity, @NonNull ToLongFunction<T> getSequenceNumberFromEntry) {
        super(lowestAllowedSequenceNumber, sequenceNumberCapacity, false, getSequenceNumberFromEntry);
    }

    public StandardSequenceSet(long lowestAllowedSequenceNumber, int sequenceNumberCapacity, boolean allowExpansion, @NonNull ToLongFunction<T> getSequenceNumberFromEntry) {
        super(lowestAllowedSequenceNumber, sequenceNumberCapacity, allowExpansion, getSequenceNumberFromEntry);
    }

    @Override
    @NonNull
    protected SequenceMap<T, Boolean> buildMap(long lowestAllowedSequenceNumber, int sequenceNumberCapacity, boolean allowExpansion, @NonNull ToLongFunction<T> getSequenceNumberFromEntry) {
        Objects.requireNonNull(getSequenceNumberFromEntry);
        return new StandardSequenceMap(lowestAllowedSequenceNumber, sequenceNumberCapacity, allowExpansion, getSequenceNumberFromEntry);
    }
}

