/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.v030;

import com.hedera.node.app.service.contract.impl.exec.AddressChecks;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HederaSystemContract;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;

@Singleton
public class Version030AddressChecks
implements AddressChecks {
    private final int[] systemContractNumbers;

    @Inject
    public Version030AddressChecks(@NonNull Map<Address, HederaSystemContract> systemContracts) {
        this.systemContractNumbers = new int[systemContracts.size()];
        int i = 0;
        for (Address address : systemContracts.keySet()) {
            if (address.numberOfLeadingZeroBytes() != 18) {
                throw new IllegalArgumentException("Precompile address " + String.valueOf(address) + " is outside system range");
            }
            this.systemContractNumbers[i++] = address.getInt(16);
        }
    }

    @Override
    public boolean isPresent(@NonNull Address address, @NonNull MessageFrame frame) {
        return this.isHederaPrecompile(address) || frame.getWorldUpdater().get(address) != null;
    }

    @Override
    public boolean isSystemAccount(@NonNull Address address) {
        return false;
    }

    @Override
    public boolean isNonUserAccount(@NonNull Address address) {
        return false;
    }

    @Override
    public boolean isHederaPrecompile(@NonNull Address address) {
        return address.numberOfLeadingZeroBytes() >= 18 && this.isPrecompile(address.getInt(16));
    }

    private boolean isPrecompile(int number) {
        for (int precompileNumber : this.systemContractNumbers) {
            if (precompileNumber != number) continue;
            return true;
        }
        return false;
    }
}

