/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes48;
import org.hyperledger.besu.ethereum.rlp.RLPInput;
import org.hyperledger.besu.ethereum.rlp.RLPOutput;

public class KZGCommitment {
    final Bytes48 data;

    public KZGCommitment(Bytes48 data) {
        this.data = data;
    }

    public static KZGCommitment readFrom(RLPInput input) {
        Bytes48 bytes = input.readBytes48();
        return new KZGCommitment(bytes);
    }

    public void writeTo(RLPOutput out) {
        out.writeBytes((Bytes)this.data);
    }

    public Bytes48 getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KZGCommitment that = (KZGCommitment)o;
        return Objects.equals(this.getData(), that.getData());
    }

    public int hashCode() {
        return Objects.hash(this.getData());
    }
}

